/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import org.joda.time.DateTime;

public final class Schedule
extends PushModelObject {
    private final DateTime scheduledTimestamp;
    private final Boolean localTimePresent;

    private Schedule(DateTime scheduledTimestamp, boolean localTimePresent) {
        this.scheduledTimestamp = scheduledTimestamp;
        this.localTimePresent = localTimePresent;
    }

    public DateTime getScheduledTimestamp() {
        return this.scheduledTimestamp;
    }

    public Boolean getLocalTimePresent() {
        return this.localTimePresent;
    }

    public String toString() {
        return "Schedule{scheduledTimestamp=" + this.scheduledTimestamp + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scheduledTimestamp, this.localTimePresent});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return Objects.equal((Object)this.scheduledTimestamp, (Object)other.scheduledTimestamp) && Objects.equal((Object)this.localTimePresent, (Object)other.localTimePresent);
    }

    public static class Builder {
        private DateTime scheduledTimestamp = null;
        private Boolean localTimePresent = false;

        private Builder() {
        }

        public Builder setScheduledTimestamp(DateTime scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
            this.localTimePresent = false;
            return this;
        }

        public Builder setLocalScheduledTimestamp(DateTime scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
            this.localTimePresent = true;
            return this;
        }

        public Schedule build() {
            Preconditions.checkArgument((this.scheduledTimestamp != null ? 1 : 0) != 0, (Object)"Either scheduled_time or local_scheduled_time must be set.");
            return new Schedule(this.scheduledTimestamp, this.localTimePresent);
        }
    }
}

