/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.parse;

import com.urbanairship.api.segments.model.AudienceSegment;
import com.urbanairship.api.segments.parse.OperatorSerializer;
import com.urbanairship.api.segments.parse.PredicateSerializer;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudienceSegmentSerializer
extends JsonSerializer<AudienceSegment> {
    public static final AudienceSegmentSerializer INSTANCE = new AudienceSegmentSerializer(OperatorSerializer.INSTANCE, PredicateSerializer.INSTANCE);
    private final OperatorSerializer operatorSerializer;
    private final PredicateSerializer predicateSerializer;

    private AudienceSegmentSerializer(OperatorSerializer operatorSerializer, PredicateSerializer predicateSerializer) {
        this.operatorSerializer = operatorSerializer;
        this.predicateSerializer = predicateSerializer;
    }

    public void serialize(AudienceSegment value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeFieldName("display_name");
        jgen.writeString(value.getDisplayName());
        jgen.writeFieldName("criteria");
        if (value.isOperatorRoot()) {
            this.operatorSerializer.serialize(value.getRootOperator(), jgen, provider);
        } else if (value.isPredicateRoot()) {
            this.predicateSerializer.serialize(value.getRootPredicate(), jgen, provider);
        }
        if (value.hasCount()) {
            jgen.writeFieldName("count");
            jgen.writeString(String.valueOf(value.getCount()));
        }
        jgen.writeEndObject();
    }
}

