/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.parse;

import com.urbanairship.api.segments.model.DateRange;
import com.urbanairship.api.segments.model.LocationPredicate;
import com.urbanairship.api.segments.model.RecentDateRange;
import com.urbanairship.api.segments.parse.LocationIdentifierSerializer;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationPredicateSerializer
extends JsonSerializer<LocationPredicate> {
    public static final LocationPredicateSerializer INSTANCE = new LocationPredicateSerializer(LocationIdentifierSerializer.INSTANCE);
    private static final DateRangeSerializer DATE_RANGE_SERIALIZER = new DateRangeSerializer();
    private static final RecentDateRangeSerializer RECENT_DATE_RANGE_SERIALIZER = new RecentDateRangeSerializer();
    private final LocationIdentifierSerializer locationIdentifierSerializer;

    private LocationPredicateSerializer(LocationIdentifierSerializer locationIdentifierSerializer) {
        this.locationIdentifierSerializer = locationIdentifierSerializer;
    }

    public void serialize(LocationPredicate value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeFieldName("location");
        jgen.writeStartObject();
        this.locationIdentifierSerializer.serialize(value.getLocationIdentifier(), jgen, provider);
        this.writeDateSpecifier(value, jgen, provider);
        jgen.writeEndObject();
        jgen.writeEndObject();
    }

    private void writeDateSpecifier(LocationPredicate value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeFieldName("date");
        jgen.writeStartObject();
        if (value.isRecentDateRangeBounded()) {
            RECENT_DATE_RANGE_SERIALIZER.serialize(value.getRecentDateRange(), jgen, provider);
        } else {
            DATE_RANGE_SERIALIZER.serialize(value.getDateRange(), jgen, provider);
        }
        jgen.writeEndObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecentDateRangeSerializer
    extends JsonSerializer<RecentDateRange> {
        private RecentDateRangeSerializer() {
        }

        public void serialize(RecentDateRange value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeFieldName("recent");
            jgen.writeStartObject();
            jgen.writeFieldName(value.getDateRangeUnit().getIdentifier());
            jgen.writeNumber(value.getUnits());
            jgen.writeEndObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateRangeSerializer
    extends JsonSerializer<DateRange> {
        private DateRangeSerializer() {
        }

        public void serialize(DateRange value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeFieldName(value.getDateRangeUnit().getIdentifier());
            jgen.writeStartObject();
            jgen.writeFieldName("start");
            jgen.writeString(value.getRangeStart());
            jgen.writeFieldName("end");
            jgen.writeString(value.getRangeEnd());
            jgen.writeEndObject();
        }
    }
}

