/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.parse;

import com.urbanairship.api.segments.model.Operator;
import com.urbanairship.api.segments.model.OperatorChild;
import com.urbanairship.api.segments.model.OperatorType;
import com.urbanairship.api.segments.parse.PredicateSerializer;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorSerializer
extends JsonSerializer<Operator> {
    public static final OperatorSerializer INSTANCE = new OperatorSerializer(PredicateSerializer.INSTANCE);
    private final PredicateSerializer predicateSerializer;

    private OperatorSerializer(PredicateSerializer predicateSerializer) {
        this.predicateSerializer = predicateSerializer;
    }

    public void serialize(Operator value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeFieldName(value.getType().getIdentifier());
        if (value.getType() != OperatorType.NOT) {
            jgen.writeStartArray();
        }
        for (OperatorChild child : value.getChildren()) {
            if (child.isPredicateChild()) {
                this.predicateSerializer.serialize(child.getPredicate(), jgen, provider);
                continue;
            }
            this.serialize(child.getOperator(), jgen, provider);
        }
        if (value.getType() != OperatorType.NOT) {
            jgen.writeEndArray();
        }
        jgen.writeEndObject();
    }
}

