/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.parse;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.segments.model.Predicate;
import com.urbanairship.api.segments.parse.InvalidAudienceSegmentException;
import com.urbanairship.api.segments.parse.LocationPredicateDeserializer;
import com.urbanairship.api.segments.parse.TagPredicateDeserializer;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateDeserializer
extends JsonDeserializer<Predicate> {
    public static final PredicateDeserializer INSTANCE = new PredicateDeserializer();
    private static final Map<String, JsonDeserializer<? extends Predicate>> PREDICATE_DESERIALIZERS = ImmutableMap.of((Object)"tag", (Object)((Object)TagPredicateDeserializer.INSTANCE), (Object)"tag_class", (Object)((Object)TagPredicateDeserializer.INSTANCE), (Object)"location", (Object)((Object)LocationPredicateDeserializer.INSTANCE));
    private static final String INVALID_PREDICATE = "Segment criteria predicates must be simple key value pair objects";
    private static final String UNRECOGNIZED_PREDICATE_TYPE = "Unrecognized predicate type.  Valid predicate types are - " + Joiner.on((String)", ").join(PREDICATE_DESERIALIZERS.keySet()) + ".";

    private PredicateDeserializer() {
    }

    public Predicate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken token = jp.getCurrentToken();
        if (token == JsonToken.START_OBJECT) {
            token = jp.nextToken();
        }
        if (token != JsonToken.FIELD_NAME) {
            throw new InvalidAudienceSegmentException(INVALID_PREDICATE);
        }
        JsonDeserializer<? extends Predicate> predicateDeserializer = PREDICATE_DESERIALIZERS.get(jp.getText());
        if (predicateDeserializer == null) {
            throw new InvalidAudienceSegmentException(UNRECOGNIZED_PREDICATE_TYPE);
        }
        jp.nextToken();
        Predicate predicate = (Predicate)predicateDeserializer.deserialize(jp, ctxt);
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken.equals((Object)JsonToken.END_OBJECT)) {
            return predicate;
        }
        if (jp.nextToken().equals((Object)JsonToken.END_OBJECT)) {
            return predicate;
        }
        throw new InvalidAudienceSegmentException(INVALID_PREDICATE);
    }
}

