/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.parse;

import com.google.common.collect.Maps;
import com.urbanairship.api.segments.model.LocationPredicate;
import com.urbanairship.api.segments.model.Predicate;
import com.urbanairship.api.segments.model.TagPredicate;
import com.urbanairship.api.segments.parse.InvalidAudienceSegmentException;
import com.urbanairship.api.segments.parse.LocationPredicateSerializer;
import com.urbanairship.api.segments.parse.TagPredicateSerializer;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateSerializer {
    public static final PredicateSerializer INSTANCE = new PredicateSerializer();
    private static final Map<Class<? extends Predicate>, JsonSerializer<? extends Predicate>> SERIALIZERS = Maps.newHashMap();

    private PredicateSerializer() {
    }

    private static <T extends Predicate> void register(Class<T> clazz, JsonSerializer<T> serializer) {
        SERIALIZERS.put(clazz, serializer);
    }

    public <T extends Predicate> void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        JsonSerializer<? extends Predicate> jsonSerializer = SERIALIZERS.get(value.getClass());
        if (jsonSerializer == null) {
            throw new InvalidAudienceSegmentException("Unknown Predicate class " + value.getClass());
        }
        jsonSerializer.serialize(value, jgen, provider);
    }

    static {
        PredicateSerializer.register(TagPredicate.class, TagPredicateSerializer.INSTANCE);
        PredicateSerializer.register(LocationPredicate.class, LocationPredicateSerializer.INSTANCE);
    }
}

