/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.tag.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.tag.model.AddRemoveSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddRemoveDeviceFromTagPayload
extends PushModelObject {
    private final Optional<AddRemoveSet> iosChannels;
    private final Optional<AddRemoveSet> androidChannels;
    private final Optional<AddRemoveSet> amazonChannels;
    private final Optional<AddRemoveSet> deviceTokens;
    private final Optional<AddRemoveSet> devicePins;
    private final Optional<AddRemoveSet> apids;

    private AddRemoveDeviceFromTagPayload(Optional<AddRemoveSet> iosChannels, Optional<AddRemoveSet> amazonChannels, Optional<AddRemoveSet> androidChannels, Optional<AddRemoveSet> deviceTokens, Optional<AddRemoveSet> devicePins, Optional<AddRemoveSet> apids) {
        this.iosChannels = iosChannels;
        this.amazonChannels = amazonChannels;
        this.androidChannels = androidChannels;
        this.deviceTokens = deviceTokens;
        this.devicePins = devicePins;
        this.apids = apids;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<AddRemoveSet> getIOSChannels() {
        return this.iosChannels;
    }

    public Optional<AddRemoveSet> getAndroidChannels() {
        return this.androidChannels;
    }

    public Optional<AddRemoveSet> getAmazonChannels() {
        return this.amazonChannels;
    }

    public Optional<AddRemoveSet> getDeviceTokens() {
        return this.deviceTokens;
    }

    public Optional<AddRemoveSet> getDevicePins() {
        return this.devicePins;
    }

    public Optional<AddRemoveSet> getApids() {
        return this.apids;
    }

    public String toString() {
        return "AddRemoveDeviceFromTagPayload{iosChannels=" + this.iosChannels + ", androidChannels=" + this.androidChannels + ", amazonChannels=" + this.amazonChannels + ", deviceTokens=" + this.deviceTokens + ", devicePins=" + this.devicePins + ", apids=" + this.apids + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.iosChannels, this.androidChannels, this.amazonChannels, this.deviceTokens, this.devicePins, this.apids});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddRemoveDeviceFromTagPayload other = (AddRemoveDeviceFromTagPayload)obj;
        return Objects.equal(this.iosChannels, other.iosChannels) && Objects.equal(this.deviceTokens, other.deviceTokens) && Objects.equal(this.devicePins, other.devicePins) && Objects.equal(this.apids, other.apids);
    }

    public static class Builder {
        private AddRemoveSet ios_channels = null;
        private AddRemoveSet android_channels = null;
        private AddRemoveSet amazon_channels = null;
        private AddRemoveSet device_tokens = null;
        private AddRemoveSet device_pins = null;
        private AddRemoveSet apids = null;

        private Builder() {
        }

        public Builder setIOSChannels(AddRemoveSet value) {
            this.ios_channels = value;
            return this;
        }

        public Builder setAndroidChannels(AddRemoveSet value) {
            this.android_channels = value;
            return this;
        }

        public Builder setAmazonChannels(AddRemoveSet value) {
            this.amazon_channels = value;
            return this;
        }

        public Builder setDeviceTokens(AddRemoveSet value) {
            this.device_tokens = value;
            return this;
        }

        public Builder setDevicePins(AddRemoveSet value) {
            this.device_pins = value;
            return this;
        }

        public Builder setApids(AddRemoveSet value) {
            this.apids = value;
            return this;
        }

        public AddRemoveDeviceFromTagPayload build() {
            Preconditions.checkArgument((this.ios_channels != null || this.android_channels != null || this.amazon_channels != null || this.device_tokens != null || this.device_pins != null || this.apids != null ? 1 : 0) != 0, (Object)"Tag mutations must be set for at least one device identifier type");
            return new AddRemoveDeviceFromTagPayload(Optional.fromNullable((Object)this.ios_channels), Optional.fromNullable((Object)this.android_channels), Optional.fromNullable((Object)this.amazon_channels), Optional.fromNullable((Object)this.device_tokens), Optional.fromNullable((Object)this.device_pins), Optional.fromNullable((Object)this.apids));
        }
    }
}

