/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.tag.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddRemoveSet {
    private final Optional<ImmutableSet<String>> add;
    private final Optional<ImmutableSet<String>> remove;

    private AddRemoveSet(Optional<ImmutableSet<String>> add, Optional<ImmutableSet<String>> remove) {
        this.add = add;
        this.remove = remove;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<ImmutableSet<String>> getAdd() {
        return this.add;
    }

    public Optional<ImmutableSet<String>> getRemove() {
        return this.remove;
    }

    public String toString() {
        return "AddRemoveSet{add=" + this.add + ", remove=" + this.remove + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.add, this.remove});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddRemoveSet other = (AddRemoveSet)obj;
        return Objects.equal(this.add, other.add) && Objects.equal(this.remove, other.remove);
    }

    public static class Builder {
        private ImmutableSet.Builder<String> add = null;
        private ImmutableSet.Builder<String> remove = null;

        private Builder() {
        }

        public Builder add(String value) {
            if (this.add == null) {
                this.add = ImmutableSet.builder();
            }
            this.add.add((Object)value);
            return this;
        }

        public Builder remove(String value) {
            if (this.remove == null) {
                this.remove = ImmutableSet.builder();
            }
            this.remove.add((Object)value);
            return this;
        }

        public AddRemoveSet build() {
            Preconditions.checkArgument((this.add != null || this.remove != null ? 1 : 0) != 0, (Object)"There must be something to add and/or remove");
            return new AddRemoveSet(this.add != null ? Optional.fromNullable((Object)this.add.build()) : null, this.remove != null ? Optional.fromNullable((Object)this.remove.build()) : null);
        }
    }
}

