/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.tag.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.tag.model.BatchTagSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchModificationPayload
extends PushModelObject {
    private final ImmutableSet<BatchTagSet> batchObject;

    private BatchModificationPayload(ImmutableSet<BatchTagSet> set) {
        this.batchObject = set;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ImmutableSet<BatchTagSet> getBatchObjects() {
        return this.batchObject;
    }

    public String toString() {
        return "BatchModificationPayload{batchObject=" + this.batchObject + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.batchObject});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BatchModificationPayload other = (BatchModificationPayload)obj;
        return Objects.equal(this.batchObject, other.batchObject);
    }

    public static class Builder {
        private ImmutableSet.Builder<BatchTagSet> batch_object = null;

        private Builder() {
        }

        public Builder addBatchObject(BatchTagSet value) {
            if (this.batch_object == null) {
                this.batch_object = ImmutableSet.builder();
            }
            this.batch_object.add((Object)value);
            return this;
        }

        public BatchModificationPayload build() {
            Preconditions.checkNotNull(this.batch_object, (Object)"There must be a batch object");
            return new BatchModificationPayload(this.batch_object.build());
        }
    }
}

