/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.tag.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchTagSet {
    private final DeviceIdTypes idType;
    private final String deviceID;
    private final ImmutableSet<String> tags;

    private BatchTagSet(DeviceIdTypes idType, String deviceID, ImmutableSet<String> tags) {
        this.idType = idType;
        this.deviceID = deviceID;
        this.tags = tags;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public DeviceIdTypes getIdType() {
        return this.idType;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public ImmutableSet<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "BatchTagSet{idType=" + (Object)((Object)this.idType) + ", deviceID='" + this.deviceID + '\'' + ", tags=" + this.tags + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.idType, this.deviceID, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BatchTagSet other = (BatchTagSet)obj;
        return Objects.equal((Object)((Object)this.idType), (Object)((Object)other.idType)) && Objects.equal((Object)this.deviceID, (Object)other.deviceID) && Objects.equal(this.tags, other.tags);
    }

    public static class Builder {
        private DeviceIdTypes id_type = null;
        private String device_id = null;
        private ImmutableSet.Builder<String> tags = null;

        private Builder() {
        }

        public Builder setDevice(DeviceIdTypes type, String id) {
            this.id_type = type;
            this.device_id = id;
            return this;
        }

        public Builder addTag(String value) {
            if (this.tags == null) {
                this.tags = ImmutableSet.builder();
            }
            this.tags.add((Object)value);
            return this;
        }

        public BatchTagSet build() {
            Preconditions.checkNotNull((Object)((Object)this.id_type), (Object)"There must be a type specified");
            Preconditions.checkNotNull((Object)this.device_id, (Object)"There must be a device id");
            Preconditions.checkNotNull(this.tags, (Object)"There must be tags to apply");
            return new BatchTagSet(this.id_type, this.device_id, this.tags.build());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeviceIdTypes {
        IOS_CHANNEL,
        ANDROID_CHANNEL,
        AMAZON_CHANNEL,
        DEVICE_TOKEN,
        APID;

    }
}

