/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;

public class SmsRegistrationResponse {
    private final boolean ok;
    private final Optional<String> channelId;
    private final Optional<String> status;
    private final Optional<String> errors;

    private SmsRegistrationResponse(Builder builder) {
        this.ok = builder.ok;
        this.channelId = Optional.fromNullable((Object)builder.channelId);
        this.status = Optional.fromNullable((Object)builder.status);
        this.errors = Optional.fromNullable((Object)builder.errors);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isOk() {
        return this.ok;
    }

    public Optional<String> getChannelId() {
        return this.channelId;
    }

    public Optional<String> getStatus() {
        return this.status;
    }

    public Optional<String> getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsRegistrationResponse that = (SmsRegistrationResponse)o;
        return this.ok == that.ok && Objects.equal(this.channelId, that.channelId) && Objects.equal(this.status, that.status) && Objects.equal(this.errors, that.errors);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.channelId, this.status, this.errors});
    }

    public static class Builder {
        private boolean ok;
        private String channelId = null;
        private String status = null;
        private String errors = null;

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder setErrors(String errors) {
            this.errors = errors;
            return this;
        }

        public SmsRegistrationResponse build() {
            return new SmsRegistrationResponse(this);
        }
    }
}

