/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.parse;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.urbanairship.api.channel.model.ChannelResponse;
import com.urbanairship.api.channel.model.ChannelView;
import com.urbanairship.api.channel.model.OpenChannelResponse;
import com.urbanairship.api.channel.model.SmsRegistrationResponse;
import com.urbanairship.api.channel.model.email.EmailChannelResponse;
import com.urbanairship.api.channel.model.email.RegisterEmailChannel;
import com.urbanairship.api.channel.model.ios.IosSettings;
import com.urbanairship.api.channel.model.ios.QuietTime;
import com.urbanairship.api.channel.model.open.OpenChannel;
import com.urbanairship.api.channel.model.web.Subscription;
import com.urbanairship.api.channel.model.web.WebSettings;
import com.urbanairship.api.channel.parse.ChannelViewDeserializer;
import com.urbanairship.api.channel.parse.ChannelsResponseDeserializer;
import com.urbanairship.api.channel.parse.OpenChannelResponseDeserializer;
import com.urbanairship.api.channel.parse.SmsRegistrationResponseDeserializer;
import com.urbanairship.api.channel.parse.email.RegisterEmailChannelResponseDeserializer;
import com.urbanairship.api.channel.parse.email.RegisterEmailChannelSerializer;
import com.urbanairship.api.channel.parse.ios.IosSettingsDeserializer;
import com.urbanairship.api.channel.parse.ios.QuietTimeDeserializer;
import com.urbanairship.api.channel.parse.open.OpenChannelDeserializer;
import com.urbanairship.api.channel.parse.web.SubscriptionDeserializer;
import com.urbanairship.api.channel.parse.web.WebSettingsDeserializer;
import com.urbanairship.api.createandsend.model.audience.email.EmailChannel;
import com.urbanairship.api.createandsend.parse.CreateAndSendEmailChannelSerializer;
import com.urbanairship.api.push.parse.PushObjectMapper;

public class ChannelObjectMapper {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final SimpleModule MODULE = new SimpleModule("Channels API Module", new Version(1, 0, 0, null));

    public static SimpleModule getModule() {
        return MODULE;
    }

    public static ObjectMapper getInstance() {
        return MAPPER;
    }

    private ChannelObjectMapper() {
    }

    static {
        MODULE.addDeserializer(IosSettings.class, (JsonDeserializer)new IosSettingsDeserializer());
        MODULE.addDeserializer(QuietTime.class, (JsonDeserializer)new QuietTimeDeserializer());
        MODULE.addDeserializer(ChannelView.class, (JsonDeserializer)new ChannelViewDeserializer());
        MODULE.addDeserializer(ChannelResponse.class, (JsonDeserializer)new ChannelsResponseDeserializer());
        MODULE.addDeserializer(Subscription.class, (JsonDeserializer)new SubscriptionDeserializer());
        MODULE.addDeserializer(WebSettings.class, (JsonDeserializer)new WebSettingsDeserializer());
        MODULE.addDeserializer(OpenChannel.class, (JsonDeserializer)new OpenChannelDeserializer());
        MODULE.addDeserializer(OpenChannelResponse.class, (JsonDeserializer)new OpenChannelResponseDeserializer());
        MODULE.addDeserializer(EmailChannelResponse.class, (JsonDeserializer)new RegisterEmailChannelResponseDeserializer());
        MODULE.addSerializer(RegisterEmailChannel.class, (JsonSerializer)new RegisterEmailChannelSerializer());
        MODULE.addDeserializer(SmsRegistrationResponse.class, (JsonDeserializer)new SmsRegistrationResponseDeserializer());
        MODULE.addSerializer(EmailChannel.class, (JsonSerializer)new CreateAndSendEmailChannelSerializer());
        MAPPER.registerModule((Module)MODULE);
        MAPPER.registerModule((Module)new JodaModule());
        MAPPER.registerModule((Module)PushObjectMapper.getModule());
        MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }
}

