/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.channel.model.ChannelView;
import com.urbanairship.api.channel.model.ios.IosSettings;
import com.urbanairship.api.channel.model.open.OpenChannel;
import com.urbanairship.api.channel.model.web.WebSettings;
import com.urbanairship.api.client.UrbanAirshipClient;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.BooleanFieldDeserializer;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.ListOfStringsDeserializer;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelViewReader
implements JsonObjectReader<ChannelView> {
    private static final Logger log = LoggerFactory.getLogger(UrbanAirshipClient.class);
    private final ChannelView.Builder builder = ChannelView.newBuilder();

    public void readChannelId(JsonParser jsonParser) throws IOException {
        this.builder.setChannelId(StringFieldDeserializer.INSTANCE.deserialize(jsonParser, "channel_id"));
    }

    public void readDeviceType(JsonParser jsonParser) throws IOException {
        this.builder.setChannelType(StringFieldDeserializer.INSTANCE.deserialize(jsonParser, "device_type"));
    }

    public void readInstalled(JsonParser jsonParser) throws IOException {
        this.builder.setInstalled(BooleanFieldDeserializer.INSTANCE.deserialize(jsonParser, "installed"));
    }

    public void readOptIn(JsonParser jsonParser) throws IOException {
        this.builder.setOptIn(BooleanFieldDeserializer.INSTANCE.deserialize(jsonParser, "opt_in"));
    }

    public void readBackground(JsonParser jsonParser) throws IOException {
        this.builder.setBackground(BooleanFieldDeserializer.INSTANCE.deserialize(jsonParser, "background"));
    }

    public void readPushAddress(JsonParser jsonParser) throws IOException {
        this.builder.setPushAddress((String)jsonParser.readValueAs(String.class));
    }

    public void readCreated(JsonParser jsonParser) throws IOException {
        this.builder.setCreated((DateTime)jsonParser.readValueAs(DateTime.class));
    }

    public void readLastRegistration(JsonParser jsonParser) throws IOException {
        this.builder.setLastRegistration((DateTime)jsonParser.readValueAs(DateTime.class));
    }

    public void readAlias(JsonParser jsonParser) throws IOException {
        this.builder.setAlias((String)jsonParser.readValueAs(String.class));
    }

    public void readTags(JsonParser jsonParser) throws IOException {
        this.builder.addAllTags(ListOfStringsDeserializer.INSTANCE.deserialize(jsonParser, "tags"));
    }

    public void readTagGroups(JsonParser jsonParser) throws IOException {
        Map mutableTagGroups = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, Set<String>>>(){});
        ImmutableMap<String, ImmutableSet<String>> tagGroups = ChannelViewReader.immutableMapConverter(mutableTagGroups);
        this.builder.addAllTagGroups(tagGroups);
    }

    public void readIosSettings(JsonParser jsonParser) throws IOException {
        this.builder.setIosSettings((IosSettings)jsonParser.readValueAs(IosSettings.class));
    }

    public void readWeb(JsonParser jsonParser) throws IOException {
        this.builder.setWebSettings((WebSettings)jsonParser.readValueAs(WebSettings.class));
    }

    public void readOpenChannel(JsonParser jsonParser) throws IOException {
        this.builder.setOpenChannel((OpenChannel)jsonParser.readValueAs(OpenChannel.class));
    }

    public void readAddress(JsonParser jsonParser) throws IOException {
        this.builder.setAddress((String)jsonParser.readValueAs(String.class));
    }

    public void readNamedUser(JsonParser jsonParser) throws IOException {
        this.builder.setNamedUser((String)jsonParser.readValueAs(String.class));
    }

    @Override
    public ChannelView validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }

    private static ImmutableMap<String, ImmutableSet<String>> immutableMapConverter(Map<String, Set<String>> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        return builder.build();
    }
}

