/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.notification.email;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.createandsend.model.notification.email.EmailFields;
import com.urbanairship.api.createandsend.model.notification.email.VariableDetail;
import java.util.List;

public class EmailTemplate {
    private final Optional<String> templateId;
    private final Optional<List<VariableDetail>> variableDetails;
    private final Optional<EmailFields> fields;

    private EmailTemplate(Builder builder) {
        this.templateId = Optional.fromNullable((Object)builder.templateId);
        this.fields = Optional.fromNullable((Object)builder.emailFields);
        this.variableDetails = !builder.variableDetails.build().isEmpty() ? Optional.fromNullable((Object)builder.variableDetails.build()) : Optional.absent();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getTemplateId() {
        return this.templateId;
    }

    public Optional<List<VariableDetail>> getVariableDetails() {
        return this.variableDetails;
    }

    public Optional<EmailFields> getFields() {
        return this.fields;
    }

    public static class Builder {
        private ImmutableList.Builder<VariableDetail> variableDetails = ImmutableList.builder();
        private String templateId = null;
        private EmailFields emailFields = null;

        public Builder addVariableDetail(VariableDetail variableDetail) {
            this.variableDetails.add((Object)variableDetail);
            return this;
        }

        public Builder setEmailFields(EmailFields emailFields) {
            this.emailFields = emailFields;
            return this;
        }

        public Builder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public EmailTemplate build() {
            Preconditions.checkArgument((this.templateId == null || this.emailFields == null ? 1 : 0) != 0, (Object)"the template id or emailFields value must be set, not both.");
            Preconditions.checkArgument((this.templateId != null || this.emailFields != null ? 1 : 0) != 0, (Object)"The template id or email fields must be set.");
            return new EmailTemplate(this);
        }
    }
}

