/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.location.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.location.model.LocationView;

public final class LocationResponse {
    private final Optional<ImmutableList<LocationView>> features;

    private LocationResponse(ImmutableList<LocationView> features) {
        this.features = Optional.fromNullable(features);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<ImmutableList<LocationView>> getFeatures() {
        return this.features;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.features});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocationResponse other = (LocationResponse)obj;
        return Objects.equal(this.features, other.features);
    }

    public String toString() {
        return "APILocationResponse{features=" + this.features + '}';
    }

    public static class Builder {
        private ImmutableList.Builder<LocationView> features = ImmutableList.builder();

        private Builder() {
        }

        public Builder addAllFeatures(Iterable<? extends LocationView> value) {
            this.features.addAll(value);
            return this;
        }

        public LocationResponse build() {
            return new LocationResponse(this.features.build());
        }
    }
}

