/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.Display;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.actions.Actions;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

public class InApp {
    private final String alert;
    private final String displayType;
    private final Optional<DateTime> expiry;
    private final Optional<Display> display;
    private final Optional<Actions> actions;
    private final Optional<Interactive> interactive;
    private final Optional<ImmutableMap<String, String>> extra;

    public static Builder newBuilder() {
        return new Builder();
    }

    private InApp(Builder builder) {
        this.alert = builder.alert;
        this.displayType = builder.displayType;
        this.expiry = Optional.fromNullable((Object)builder.expiry);
        this.display = Optional.fromNullable((Object)builder.display);
        this.actions = Optional.fromNullable((Object)builder.actions);
        this.interactive = Optional.fromNullable((Object)builder.interactive);
        this.extra = builder.extra.build().isEmpty() ? Optional.absent() : Optional.fromNullable((Object)builder.extra.build());
    }

    public String getAlert() {
        return this.alert;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public Optional<DateTime> getExpiry() {
        return this.expiry;
    }

    public Optional<Display> getDisplay() {
        return this.display;
    }

    public Optional<Actions> getActions() {
        return this.actions;
    }

    public Optional<Interactive> getInteractive() {
        return this.interactive;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public String toString() {
        return "InApp{alert=" + this.alert + ", displayType=" + this.displayType + ", expiry=" + this.expiry + ", actions=" + this.actions + ", interactive=" + this.interactive + ", extra=" + this.extra + '}';
    }

    public int hashCode() {
        return Objects.hash(this.alert, this.displayType, this.expiry, this.display, this.actions, this.interactive, this.extra);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InApp other = (InApp)obj;
        return Objects.equals(this.alert, other.alert) && Objects.equals(this.displayType, other.displayType) && Objects.equals(this.expiry, other.expiry) && Objects.equals(this.display, other.display) && Objects.equals(this.actions, other.actions) && Objects.equals(this.interactive, other.interactive) && Objects.equals(this.extra, other.extra);
    }

    public static class Builder {
        private String alert = null;
        private String displayType = "banner";
        private DateTime expiry = null;
        private Display display = null;
        private Actions actions = null;
        private Interactive interactive = null;
        private ImmutableMap.Builder<String, String> extra = ImmutableMap.builder();

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setExpiry(DateTime expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder setActions(Actions actions) {
            this.actions = actions;
            return this;
        }

        public Builder setDisplay(Display display) {
            this.display = display;
            return this;
        }

        public Builder setInteractive(Interactive interactive) {
            this.interactive = interactive;
            return this;
        }

        public Builder addExtra(String key, String val) {
            this.extra.put((Object)key, (Object)val);
            return this;
        }

        public Builder addAllExtras(Map<String, String> entries) {
            this.extra.putAll(entries);
            return this;
        }

        public InApp build() {
            Preconditions.checkArgument((this.alert != null ? 1 : 0) != 0, (Object)"Alert must be specified for in-app messages.");
            return new InApp(this);
        }
    }
}

