/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.web;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.web.WebIcon;
import java.util.Map;

public final class WebDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<String> alert;
    private final Optional<String> title;
    private final Optional<ImmutableMap<String, String>> extra;
    private final Optional<WebIcon> webIcon;
    private final Optional<Boolean> requireInteraction;

    private WebDevicePayload(Builder builder) {
        this.alert = Optional.fromNullable((Object)builder.alert);
        this.title = Optional.fromNullable((Object)builder.title);
        this.webIcon = Optional.fromNullable((Object)builder.webIcon);
        this.requireInteraction = Optional.fromNullable((Object)builder.requireInteraction);
        this.extra = builder.extra.build().isEmpty() ? Optional.absent() : Optional.of((Object)builder.extra.build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.WEB;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public Optional<WebIcon> getWebIcon() {
        return this.webIcon;
    }

    public Optional<Boolean> getRequireInteraction() {
        return this.requireInteraction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebDevicePayload payload = (WebDevicePayload)o;
        return Objects.equal(this.alert, payload.alert) && Objects.equal(this.title, payload.title) && Objects.equal(this.extra, payload.extra) && Objects.equal(this.webIcon, payload.webIcon) && Objects.equal(this.requireInteraction, payload.requireInteraction);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alert, this.title, this.extra, this.webIcon, this.requireInteraction});
    }

    public String toString() {
        return "WebDevicePayload{alert=" + this.alert + ", title=" + this.title + ", extra=" + this.extra + ", webIcon=" + this.webIcon + ", requireInteraction=" + this.requireInteraction + '}';
    }

    public static class Builder {
        private String alert = null;
        private String title = null;
        private ImmutableMap.Builder<String, String> extra = ImmutableMap.builder();
        private WebIcon webIcon = null;
        private Boolean requireInteraction = null;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder addExtraEntry(String key, String value) {
            this.extra.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllExtraEntries(Map<String, String> entries) {
            this.extra.putAll(entries);
            return this;
        }

        public Builder setWebIcon(WebIcon webIcon) {
            this.webIcon = webIcon;
            return this;
        }

        public Builder setRequireInteraction(boolean value) {
            this.requireInteraction = value;
            return this;
        }

        public WebDevicePayload build() {
            return new WebDevicePayload(this);
        }
    }
}

