/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.joda.time.DateTime;

public final class StatisticsResponse {
    private final DateTime start;
    private final int ios;
    private final int blackBerry;
    private final int c2dm;
    private final int gcm;
    private final int windows8;
    private final int windowsPhone8;

    private StatisticsResponse(DateTime start, int ios, int blackBerry, int c2dm, int gcm, int windows8, int windowsPhone8) {
        this.start = start;
        this.ios = ios;
        this.blackBerry = blackBerry;
        this.c2dm = c2dm;
        this.gcm = gcm;
        this.windows8 = windows8;
        this.windowsPhone8 = windowsPhone8;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public DateTime getStart() {
        return this.start;
    }

    public int getIosCount() {
        return this.ios;
    }

    public int getBlackBerryCount() {
        return this.blackBerry;
    }

    public int getC2dmCount() {
        return this.c2dm;
    }

    public int getGcmCount() {
        return this.gcm;
    }

    public int getWindows8Count() {
        return this.windows8;
    }

    public int getWindowsPhone8Count() {
        return this.windowsPhone8;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.ios, this.blackBerry, this.c2dm, this.gcm, this.windows8, this.windowsPhone8});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StatisticsResponse other = (StatisticsResponse)obj;
        return Objects.equal((Object)this.start, (Object)other.start) && Objects.equal((Object)this.ios, (Object)other.ios) && Objects.equal((Object)this.blackBerry, (Object)other.blackBerry) && Objects.equal((Object)this.c2dm, (Object)other.c2dm) && Objects.equal((Object)this.gcm, (Object)other.gcm) && Objects.equal((Object)this.windows8, (Object)other.windows8) && Objects.equal((Object)this.windowsPhone8, (Object)other.windowsPhone8);
    }

    public String toString() {
        return "AppStats{start=" + this.start + ", ios=" + this.ios + ", blackBerry=" + this.blackBerry + ", c2dm=" + this.c2dm + ", gcm=" + this.gcm + ", windows8=" + this.windows8 + ", windowsPhone8=" + this.windowsPhone8 + '}';
    }

    public static class Builder {
        private DateTime start;
        private int ios;
        private int blackBerry;
        private int c2dm;
        private int gcm;
        private int windows8;
        private int windowsPhone8;

        private Builder() {
        }

        public Builder setStartTime(DateTime value) {
            this.start = value;
            return this;
        }

        public Builder setIosCount(int value) {
            this.ios = value;
            return this;
        }

        public Builder setBlackBerryCount(int value) {
            this.blackBerry = value;
            return this;
        }

        public Builder setC2dmCount(int value) {
            this.c2dm = value;
            return this;
        }

        public Builder setGcmCount(int value) {
            this.gcm = value;
            return this;
        }

        public Builder setWindows8Count(int value) {
            this.windows8 = value;
            return this;
        }

        public Builder setWindowsPhone8Count(int value) {
            this.windowsPhone8 = value;
            return this;
        }

        public StatisticsResponse build() {
            Preconditions.checkNotNull((Object)this.start, (Object)"There must be a start time");
            return new StatisticsResponse(this.start, this.ios, this.blackBerry, this.c2dm, this.gcm, this.windows8, this.windowsPhone8);
        }
    }
}

