/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.staticlists.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.staticlists.model.StaticListView;

public class StaticListListingResponse {
    private final boolean ok;
    private final ImmutableList<StaticListView> staticListViews;

    private StaticListListingResponse(Builder builder) {
        this.ok = builder.ok;
        this.staticListViews = builder.staticListObjects.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public ImmutableList<StaticListView> getStaticListViews() {
        return this.staticListViews;
    }

    public String toString() {
        return "StaticListListingResponse{ok=" + this.ok + ", staticListViews=" + this.staticListViews + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.staticListViews});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StaticListListingResponse other = (StaticListListingResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.staticListViews, other.staticListViews);
    }

    public static class Builder {
        private boolean ok;
        private ImmutableList.Builder<StaticListView> staticListObjects = ImmutableList.builder();

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder addStaticList(StaticListView staticListObject) {
            this.staticListObjects.add((Object)staticListObject);
            return this;
        }

        public Builder addAllStaticLists(Iterable<? extends StaticListView> staticListObjects) {
            this.staticListObjects.addAll(staticListObjects);
            return this;
        }

        public StaticListListingResponse build() {
            return new StaticListListingResponse(this);
        }
    }
}

