/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.InApp;
import com.urbanairship.api.push.model.PushOptions;
import com.urbanairship.api.push.model.notification.Notification;
import com.urbanairship.api.push.model.notification.richpush.RichPushMessage;
import com.urbanairship.api.templates.model.PartialPushPayload;
import java.io.IOException;

public class PartialPushPayloadReader
implements JsonObjectReader<PartialPushPayload> {
    private final PartialPushPayload.Builder builder = PartialPushPayload.newBuilder();

    public void readNotification(JsonParser jsonParser) throws IOException {
        this.builder.setNotification((Notification)jsonParser.readValueAs(Notification.class));
    }

    public void readPushOptions(JsonParser jsonParser) throws IOException {
        this.builder.setPushOptions((PushOptions)jsonParser.readValueAs(PushOptions.class));
    }

    public void readRichPushMessage(JsonParser jsonParser) throws IOException {
        this.builder.setRichPushMessage((RichPushMessage)jsonParser.readValueAs(RichPushMessage.class));
    }

    public void readInApp(JsonParser jsonParser) throws IOException {
        this.builder.setInApp((InApp)jsonParser.readValueAs(InApp.class));
    }

    @Override
    public PartialPushPayload validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

