/*
 * Decompiled with CFR 0.152.
 */
package com.vaushell.shaarlijavaapi;

import com.vaushell.shaarlijavaapi.ShaarliLink;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaarliClient
implements AutoCloseable {
    private static final int MAX_LINKS_BY_PAGE = 100;
    private static final Logger logger = LoggerFactory.getLogger(ShaarliClient.class);
    private HttpClient client;
    private PoolingClientConnectionManager cm;
    private String endpoint;

    public ShaarliClient(HttpClient client, String endpoint) {
        if (client == null || endpoint == null) {
            throw new NullPointerException();
        }
        this.cm = null;
        this.client = client;
        this.endpoint = ShaarliClient.cleanEnding(endpoint);
    }

    public ShaarliClient(String endpoint) {
        if (endpoint == null) {
            throw new NullPointerException();
        }
        this.endpoint = ShaarliClient.cleanEnding(endpoint);
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Mozilla/5.0 (Windows NT 5.1; rv:15.0) Gecko/20100101 Firefox/15.0.1");
        SchemeRegistry sr = new SchemeRegistry();
        sr.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        this.cm = new PoolingClientConnectionManager(sr);
        this.cm.setMaxTotal(1000);
        DefaultHttpClient lClient = new DefaultHttpClient((ClientConnectionManager)this.cm, (HttpParams)params);
        lClient.setCookieStore((CookieStore)new BasicCookieStore());
        this.client = lClient;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public boolean login(String login, String password) {
        String token;
        if (login == null || password == null) {
            throw new NullPointerException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "] login() : login=" + login);
        }
        try {
            token = this.getToken(this.endpoint.toString() + "/?do=login");
        }
        catch (IOException ex) {
            logger.error("Cannot retrieve login token", (Throwable)ex);
            return false;
        }
        try {
            this.loginImpl(login, password, token);
        }
        catch (IOException ex) {
            logger.error("Cannot retrieve login token", (Throwable)ex);
            return false;
        }
        this.setLinksByPage(100);
        return true;
    }

    public String createOrUpdateLink(String url, String title, String description, Set<String> tags, boolean restricted) {
        return this.createOrUpdateLink(null, url, title, description, tags, restricted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createOrUpdateLink(String id, String url, String title, String description, Set<String> tags, boolean restricted) {
        String string;
        String token;
        if (url == null) throw new NullPointerException();
        if (title == null) {
            throw new NullPointerException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "] createOrUpdateLink() : id=" + id + " / url=" + url + " / title=" + title + " / description=" + description + " / restricted=" + restricted);
        }
        try {
            token = this.getToken(this.endpoint.toString() + "/?post");
        }
        catch (IOException ex) {
            logger.error("Cannot retrieve post token", (Throwable)ex);
            return null;
        }
        HttpEntity responseEntity = null;
        try {
            HttpPost post = new HttpPost(this.endpoint + "/?post=" + URLEncoder.encode(url, "UTF-8"));
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            String returnID = id != null ? id : new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            nvps.add(new BasicNameValuePair("lf_linkdate", returnID));
            nvps.add(new BasicNameValuePair("lf_url", url));
            nvps.add(new BasicNameValuePair("lf_title", title));
            if (description != null) {
                nvps.add(new BasicNameValuePair("lf_description", description));
            }
            if (restricted) {
                nvps.add(new BasicNameValuePair("lf_private", "true"));
            }
            StringBuilder sbTags = new StringBuilder();
            if (tags != null) {
                for (String tag : tags) {
                    if (sbTags.length() > 0) {
                        sbTags.append(" ");
                    }
                    sbTags.append(tag);
                }
            }
            if (sbTags.length() > 0) {
                nvps.add(new BasicNameValuePair("lf_tags", sbTags.toString()));
            }
            nvps.add(new BasicNameValuePair("save_edit", "Save"));
            nvps.add(new BasicNameValuePair("token", token));
            nvps.add(new BasicNameValuePair("returnurl", this.endpoint));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            responseEntity = response.getEntity();
            StatusLine sl = response.getStatusLine();
            if (sl.getStatusCode() != 302) {
                InputStream is = responseEntity.getContent();
                Throwable throwable = null;
                try {
                    try {
                        throw new IOException(IOUtils.toString((InputStream)is));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (is == null) throw throwable3;
                    if (throwable == null) {
                        is.close();
                        throw throwable3;
                    }
                    try {
                        is.close();
                        throw throwable3;
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                        throw throwable3;
                    }
                }
            }
            string = returnID;
            if (responseEntity == null) return string;
        }
        catch (IOException ex) {
            logger.error("Cannot post", (Throwable)ex);
            String string2 = null;
            return string2;
        }
        try {
            EntityUtils.consume((HttpEntity)responseEntity);
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (responseEntity != null) {
                try {
                    EntityUtils.consume(responseEntity);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(String id) {
        boolean bl;
        String token;
        if (id == null) {
            throw new NullPointerException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "] delete() : id=" + id);
        }
        try {
            token = this.getToken(this.endpoint.toString() + "/?post");
        }
        catch (IOException ex) {
            logger.error("Cannot retrieve post token", (Throwable)ex);
            return false;
        }
        HttpEntity responseEntity = null;
        try {
            HttpPost post = new HttpPost(this.endpoint + "/?post");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("lf_linkdate", id));
            nvps.add(new BasicNameValuePair("delete_link", ""));
            nvps.add(new BasicNameValuePair("token", token));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            responseEntity = response.getEntity();
            StatusLine sl = response.getStatusLine();
            if (sl.getStatusCode() != 302) {
                InputStream is = responseEntity.getContent();
                Throwable throwable = null;
                try {
                    try {
                        throw new IOException(IOUtils.toString((InputStream)is));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (is == null) throw throwable3;
                    if (throwable == null) {
                        is.close();
                        throw throwable3;
                    }
                    try {
                        is.close();
                        throw throwable3;
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                        throw throwable3;
                    }
                }
            }
            bl = true;
            if (responseEntity == null) return bl;
        }
        catch (IOException ex) {
            logger.error("Cannot delete", (Throwable)ex);
            boolean bl2 = false;
            return bl2;
        }
        try {
            EntityUtils.consume((HttpEntity)responseEntity);
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (responseEntity != null) {
                try {
                    EntityUtils.consume(responseEntity);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Integer> getTags() {
        TreeMap<String, Integer> treeMap;
        Throwable throwable;
        InputStream is;
        HttpEntity responseEntity;
        block25: {
            block26: {
                if (logger.isDebugEnabled()) {
                    logger.debug("[" + this.getClass().getSimpleName() + "] getTags()");
                }
                responseEntity = null;
                String execURL = this.endpoint + "/?do=tagcloud";
                HttpGet get = new HttpGet(execURL);
                HttpResponse response = this.client.execute((HttpUriRequest)get);
                responseEntity = response.getEntity();
                StatusLine sl = response.getStatusLine();
                if (sl.getStatusCode() != 200) throw new IOException(sl.getReasonPhrase());
                is = responseEntity.getContent();
                throwable = null;
                TreeMap<String, Integer> tags = new TreeMap<String, Integer>();
                Document doc = Jsoup.parse((InputStream)is, (String)"utf-8", (String)execURL);
                Elements elts = doc.select("#cloudtag *");
                Iterator itElts = elts.iterator();
                while (itElts.hasNext()) {
                    int count = Integer.parseInt(((Element)itElts.next()).text());
                    String name = ((Element)itElts.next()).text();
                    tags.put(name, count);
                }
                treeMap = tags;
                if (is == null) break block25;
                if (throwable == null) break block26;
                try {
                    is.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
                break block25;
            }
            is.close();
        }
        if (responseEntity == null) return treeMap;
        try {
            EntityUtils.consume((HttpEntity)responseEntity);
            return treeMap;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (is == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    is.close();
                                    throw throwable3;
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                throw throwable3;
                            } else {
                                is.close();
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException ex) {
                        logger.error("Cannot retrieve tags", (Throwable)ex);
                        Map<String, Integer> map = null;
                        return map;
                    }
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (responseEntity != null) {
                        try {
                            EntityUtils.consume(responseEntity);
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            }
        }
    }

    public Iterator<ShaarliLink> searchAllIterator() {
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "] searchAllIterator()");
        }
        return this.iterator(null);
    }

    public List<ShaarliLink> searchAll(int page) {
        if (page < 1) {
            throw new IllegalArgumentException("page must be greater or equals to 1");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "] searchAll() : page=" + page);
        }
        String execURL = this.endpoint + "/?page=" + page;
        return this.parseLinks(execURL);
    }

    public Iterator<ShaarliLink> searchTermIterator(String term) {
        if (term == null) {
            throw new NullPointerException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "] searchTermIterator() : term=" + term);
        }
        try {
            return this.iterator("searchterm=" + URLEncoder.encode(term, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<ShaarliLink> searchTerm(int page, String term) {
        if (term == null) {
            throw new NullPointerException();
        }
        if (page < 1) {
            throw new IllegalArgumentException("page must be greater or equals to 1");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "] searchTerm() : page=" + page + " / term=" + term);
        }
        try {
            String execURL = this.endpoint + "/?page=" + page + "&searchterm=" + URLEncoder.encode(term, "UTF-8");
            return this.parseLinks(execURL);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Iterator<ShaarliLink> searchTagsIterator(String ... tags) {
        if (tags == null || tags.length <= 0) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder();
        for (String tag : tags) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(tag);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "] searchTagsIterator() : tags=" + sb.toString());
        }
        try {
            return this.iterator("searchtags=" + URLEncoder.encode(sb.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<ShaarliLink> searchTags(int page, String ... tags) {
        if (page < 1) {
            throw new IllegalArgumentException("page must be greater or equals to 1");
        }
        StringBuilder sb = new StringBuilder();
        for (String tag : tags) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(tag);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "] searchTags() : page=" + page + " / tags=" + sb.toString());
        }
        try {
            String execURL = this.endpoint + "/?page=" + page + "searchtags=" + URLEncoder.encode(sb.toString(), "UTF-8");
            return this.parseLinks(execURL);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLinksByPage(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "] setLinksByPage() : count=" + count);
        }
        HttpEntity responseEntity = null;
        try {
            String execURL = this.endpoint + "/?linksperpage=" + count;
            HttpGet get = new HttpGet(execURL);
            HttpResponse response = this.client.execute((HttpUriRequest)get);
            responseEntity = response.getEntity();
            StatusLine sl = response.getStatusLine();
            if (sl.getStatusCode() != 200) {
                throw new IOException(sl.getReasonPhrase());
            }
            if (responseEntity == null) return;
        }
        catch (IOException ex) {
            logger.error("Cannot set links per page", (Throwable)ex);
            return;
        }
        try {
            EntityUtils.consume((HttpEntity)responseEntity);
            return;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (responseEntity != null) {
                try {
                    EntityUtils.consume(responseEntity);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.cm != null) {
            this.cm.shutdown();
        }
    }

    /*
     * Exception decompiling
     */
    private String getToken(String execURL) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loginImpl(String login, String password, String token) throws IOException {
        HttpEntity responseEntity = null;
        try {
            HttpPost post = new HttpPost(this.endpoint.toString() + "/?do=login");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("login", login));
            nvps.add(new BasicNameValuePair("password", password));
            nvps.add(new BasicNameValuePair("token", token));
            nvps.add(new BasicNameValuePair("returnurl", this.endpoint));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            responseEntity = response.getEntity();
            StatusLine sl = response.getStatusLine();
            if (sl.getStatusCode() != 302) {
                InputStream is = responseEntity.getContent();
                Throwable throwable = null;
                try {
                    try {
                        throw new IOException(IOUtils.toString((InputStream)is));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (is == null) throw throwable3;
                    if (throwable != null) {
                        try {
                            is.close();
                            throw throwable3;
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        throw throwable3;
                    } else {
                        is.close();
                    }
                    throw throwable3;
                }
            }
            if (responseEntity == null) return;
        }
        catch (Throwable throwable) {
            if (responseEntity == null) throw throwable;
            EntityUtils.consume(responseEntity);
            throw throwable;
        }
        EntityUtils.consume((HttpEntity)responseEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ShaarliLink> parseLinks(String execURL) {
        ArrayList<ShaarliLink> arrayList;
        Throwable throwable;
        InputStream is;
        HttpEntity responseEntity;
        ArrayList<ShaarliLink> links;
        block27: {
            block28: {
                if (execURL == null) {
                    throw new NullPointerException();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("[" + this.getClass().getSimpleName() + "] parseLinks() : execURL=" + execURL);
                }
                links = new ArrayList<ShaarliLink>();
                responseEntity = null;
                HttpGet get = new HttpGet(execURL);
                HttpResponse response = this.client.execute((HttpUriRequest)get);
                responseEntity = response.getEntity();
                StatusLine sl = response.getStatusLine();
                if (sl.getStatusCode() != 200) throw new IOException(sl.getReasonPhrase());
                is = responseEntity.getContent();
                throwable = null;
                Document doc = Jsoup.parse((InputStream)is, (String)"utf-8", (String)execURL);
                Elements elts = doc.select("ul li");
                if (elts != null) {
                    for (Element elt : elts) {
                        String cssClass = elt.attr("class");
                        boolean restricted = cssClass != null && cssClass.equals("private");
                        String ID = elt.select("input[name=lf_linkdate").attr("value");
                        String permaID = elt.select("a[name]").attr("id");
                        String title = elt.select("span[class=linktitle]").text();
                        String description = elt.select("div[class=linkdescription]").text();
                        String url = elt.select("span[class=linkurl]").text();
                        ShaarliLink link = new ShaarliLink(ID, permaID, title, description, url, restricted);
                        Elements eltsTag = elt.select("div[class=linktaglist] a");
                        if (eltsTag != null) {
                            for (Element eltTag : eltsTag) {
                                String tag = eltTag.text();
                                link.addTag(tag);
                            }
                        }
                        links.add(link);
                    }
                }
                arrayList = links;
                if (is == null) break block27;
                if (throwable == null) break block28;
                try {
                    is.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
                break block27;
            }
            is.close();
        }
        if (responseEntity == null) return arrayList;
        try {
            EntityUtils.consume((HttpEntity)responseEntity);
            return arrayList;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (is == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    is.close();
                                    throw throwable3;
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                throw throwable3;
                            } else {
                                is.close();
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException ex) {
                        logger.error("Cannot links", (Throwable)ex);
                        ArrayList<ShaarliLink> arrayList2 = links;
                        if (responseEntity == null) return arrayList2;
                        try {
                            EntityUtils.consume((HttpEntity)responseEntity);
                            return arrayList2;
                        }
                        catch (IOException ex2) {
                            throw new RuntimeException(ex2);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (responseEntity == null) throw throwable4;
                    try {
                        EntityUtils.consume(responseEntity);
                        throw throwable4;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    private Iterator<ShaarliLink> iterator(final String query) {
        return new Iterator<ShaarliLink>(){
            private List<ShaarliLink> buffer = new ArrayList<ShaarliLink>();
            private int bufferCursor = 0;
            private int page = 1;
            private String lastID = null;

            @Override
            public boolean hasNext() {
                List links;
                if (this.bufferCursor < this.buffer.size()) {
                    return true;
                }
                this.buffer.clear();
                this.bufferCursor = 0;
                String execURL = ShaarliClient.this.endpoint + "/?page=" + this.page++;
                if (query != null && query.length() > 0) {
                    execURL = execURL + "&" + query;
                }
                if ((links = ShaarliClient.this.parseLinks(execURL)).isEmpty()) {
                    return false;
                }
                String linksLastID = ((ShaarliLink)links.get(links.size() - 1)).getID();
                if (this.lastID != null && this.lastID.equals(linksLastID)) {
                    return false;
                }
                this.lastID = linksLastID;
                this.buffer.addAll(links);
                return true;
            }

            @Override
            public ShaarliLink next() {
                return this.buffer.get(this.bufferCursor++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static String cleanEnding(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }
}

