/*
 * Decompiled with CFR 0.152.
 */
package com.vaushell.shaarlijavaapi;

import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class ShaarliLink {
    private String ID;
    private String permaID;
    private String title;
    private String description;
    private String url;
    private boolean restricted;
    private Set<String> tags;

    public ShaarliLink(String ID, String permaID, String title, String description, String url, boolean restricted) {
        this.ID = ID;
        this.permaID = permaID;
        this.title = title;
        this.description = description;
        this.url = url;
        this.restricted = restricted;
        this.tags = null;
    }

    public ShaarliLink() {
        this(null, null, null, null, null, false);
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getPermaID() {
        return this.permaID;
    }

    public String getPermaURL(String endpoint) {
        return endpoint + "/?" + this.permaID;
    }

    public void setPermaID(String permaID) {
        this.permaID = permaID;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public Set<String> getTags() {
        if (this.tags == null) {
            this.tags = new TreeSet<String>();
        }
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void addTag(String tag) {
        this.getTags().add(tag);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.ID);
        hash = 97 * hash + Objects.hashCode(this.permaID);
        hash = 97 * hash + Objects.hashCode(this.title);
        hash = 97 * hash + Objects.hashCode(this.description);
        hash = 97 * hash + Objects.hashCode(this.url);
        hash = 97 * hash + (this.restricted ? 1 : 0);
        hash = 97 * hash + Objects.hashCode(this.tags);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShaarliLink other = (ShaarliLink)obj;
        if (!Objects.equals(this.ID, other.ID)) {
            return false;
        }
        if (!Objects.equals(this.permaID, other.permaID)) {
            return false;
        }
        if (!Objects.equals(this.title, other.title)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.url, other.url)) {
            return false;
        }
        if (this.restricted != other.restricted) {
            return false;
        }
        return Objects.equals(this.tags, other.tags);
    }

    public String toString() {
        return "Link{ID=" + this.ID + ", permaID=" + this.permaID + ", title=" + this.title + ", description=" + this.description + ", url=" + this.url + ", restricted=" + this.restricted + ", tags=" + this.tags + '}';
    }
}

