/*
 * Decompiled with CFR 0.152.
 */
package com.vectorprint.vectorprintreportgui;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.steadystate.css.parser.SACParser;
import com.vectorprint.ArrayHelper;
import com.vectorprint.VectorPrintException;
import com.vectorprint.VectorPrintRuntimeException;
import com.vectorprint.configuration.EnhancedMap;
import com.vectorprint.configuration.Settings;
import com.vectorprint.configuration.binding.BindingHelper;
import com.vectorprint.configuration.binding.parameters.ParamBindingService;
import com.vectorprint.configuration.binding.parameters.ParameterHelper;
import com.vectorprint.configuration.binding.parameters.ParameterizableBindingFactory;
import com.vectorprint.configuration.binding.parameters.SpecificClassValidator;
import com.vectorprint.configuration.binding.settings.EnhancedMapBindingFactory;
import com.vectorprint.configuration.binding.settings.SettingsBindingService;
import com.vectorprint.configuration.decoration.ParsingProperties;
import com.vectorprint.configuration.decoration.SortedProperties;
import com.vectorprint.configuration.jaxb.SettingsXMLHelper;
import com.vectorprint.configuration.parameters.Parameter;
import com.vectorprint.configuration.parameters.Parameterizable;
import com.vectorprint.report.itext.EventHelper;
import com.vectorprint.report.itext.Help;
import com.vectorprint.report.itext.mappingconfig.DatamappingHelper;
import com.vectorprint.report.itext.style.BaseStyler;
import com.vectorprint.report.itext.style.DefaultStylerFactory;
import com.vectorprint.report.itext.style.DocumentStyler;
import com.vectorprint.report.itext.style.StylerFactoryHelper;
import com.vectorprint.report.itext.style.StylingCondition;
import com.vectorprint.report.itext.style.css.CssTransformer;
import com.vectorprint.report.itext.style.stylers.AbstractStyler;
import com.vectorprint.report.itext.style.stylers.Advanced;
import com.vectorprint.report.itext.style.stylers.DocumentSettings;
import com.vectorprint.report.itext.style.stylers.NewLine;
import com.vectorprint.report.itext.style.stylers.NewPage;
import com.vectorprint.report.itext.style.stylers.Padding;
import com.vectorprint.vectorprintreportgui.DefaultValue;
import com.vectorprint.vectorprintreportgui.ParameterProps;
import com.vectorprint.vectorprintreportgui.StyleClassTableController;
import com.vectorprint.vectorprintreportgui.StylesheetTester;
import com.vectorprint.vectorprintreportgui.TableViewController;
import com.vectorprint.vectorprintreportgui.ViewHelper;
import com.vectorprint.vectorprintreportgui.text.SearchableTextArea;
import com.vectorprint.vectorprintreportgui.xml.XmlArea;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.embed.swing.SwingNode;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.xml.sax.SAXException;

public class Controller
implements Initializable {
    private final ObservableMap<String, List<Parameterizable>> stylingConfig = FXCollections.observableMap(new TreeMap());
    private final Map<String, List<String>> commentsBefore = new HashMap<String, List<String>>();
    private final List<String> commentsAfter = new ArrayList<String>(3);
    private final Set<DefaultValue> defaults = new TreeSet<DefaultValue>();
    private final Map<String, String> extraSettings = new TreeMap<String, String>();
    private final ObservableList<String> styleClasses = FXCollections.observableArrayList();
    private final ObservableList<Parameterizable> parameterizableForClass;
    private static final Set<Class<? extends Parameterizable>> duplicatesAllowed = new HashSet<Class<? extends Parameterizable>>();
    @FXML
    private TableViewController tableViewController;
    @FXML
    private StyleClassTableController styleClassTableController;
    @FXML
    private ComboBox<Parameterizable> parameterizableCombo;
    @FXML
    private ComboBox<String> stylerKeys;
    @FXML
    private TextField xmlconfig;
    @FXML
    private XmlArea datamappingxsd;
    @FXML
    private TextField xmlsettings;
    @FXML
    private XmlArea settingsxsd;
    @FXML
    private ComboBox<Class<? extends EnhancedMapBindingFactory>> settingsfactory;
    @FXML
    private ComboBox<Class<? extends ParameterizableBindingFactory>> paramfactory;
    @FXML
    private CheckBox toc;
    @FXML
    private CheckBox footer;
    @FXML
    private CheckBox cssvalidate;
    @FXML
    private CheckBox pdf1a;
    @FXML
    private CheckBox debug;
    @FXML
    private CheckBox prepost;
    @FXML
    private SearchableTextArea stylesheet;
    @FXML
    private Tab pdftab;
    @FXML
    private SwingNode pdfpane;
    private SwingController controller;
    @FXML
    private SearchableTextArea help;
    @FXML
    private SearchableTextArea error;
    @FXML
    private Label stylerHelp;
    @FXML
    private Tab styleTab;
    @FXML
    private Tab helpTab;
    @FXML
    private Button pre;
    @FXML
    private Button post;
    @FXML
    private Button page;
    public final ObjectProperty<Parameterizable> currentParameterizable;
    private static final ParameterizableComparator PARAMETERIZABLE_COMPARATOR = new ParameterizableComparator();
    private static final String[] EMPTY = new String[0];
    private final Set<String> processed;

    public Controller() {
        this.stylingConfig.addListener((MapChangeListener)new MapChangeListener<String, List<Parameterizable>>(){

            public void onChanged(MapChangeListener.Change<? extends String, ? extends List<Parameterizable>> change) {
                if (change.wasAdded()) {
                    if (!Controller.this.styleClasses.contains(change.getKey())) {
                        Controller.this.styleClasses.add(change.getKey());
                        Collections.sort(Controller.this.styleClasses);
                    }
                } else if (change.wasRemoved()) {
                    Controller.this.styleClasses.remove(change.getKey());
                }
            }
        });
        this.parameterizableForClass = FXCollections.observableArrayList(new ArrayList(3));
        this.currentParameterizable = new SimpleObjectProperty();
        this.processed = new HashSet<String>(10);
    }

    @FXML
    private void chooseStandardStyle(ActionEvent event) {
        if (this.pre.equals(event.getSource())) {
            this.chooseOrAdd("PRESTYLERS");
        } else if (this.post.equals(event.getSource())) {
            this.chooseOrAdd("POSTSTYLERS");
        } else if (this.page.equals(event.getSource())) {
            this.chooseOrAdd("PAGESTYLERS");
        }
    }

    @FXML
    private void removeFromStylesheet(ActionEvent event) {
        String clazz = (String)this.stylerKeys.getValue();
        if (null == clazz || !this.stylingConfig.containsKey((Object)clazz)) {
            this.stylerKeys.requestFocus();
            return;
        }
        Iterator it = this.parameterizableForClass.iterator();
        while (it.hasNext()) {
            Parameterizable pz = (Parameterizable)it.next();
            if (pz instanceof BaseStyler && clazz.equals(((BaseStyler)pz).getStyleClass())) {
                it.remove();
                continue;
            }
            if (!(pz instanceof StylingCondition) || !clazz.equals(((StylingCondition)pz).getConfigKey())) continue;
            it.remove();
        }
        this.stylingConfig.remove((Object)clazz);
        this.styleClasses.remove((Object)clazz);
        this.commentsBefore.remove(clazz);
        this.tableViewController.getConfigString().clear();
        this.tableViewController.getParameters().clear();
        this.parameterizableForClass.clear();
    }

    private void chooseOrAdd(String styleClass) {
        if (!this.stylerKeys.getItems().contains((Object)styleClass)) {
            this.stylerKeys.getItems().add((Object)styleClass);
        }
        this.stylerKeys.getSelectionModel().select((Object)styleClass);
    }

    @FXML
    private void showStyleOrCondition(ActionEvent event) {
        if (this.stylingConfig.isEmpty() || this.stylerKeys.getValue() == null || !this.stylingConfig.containsKey(this.stylerKeys.getValue())) {
            return;
        }
        try {
            this.pickStylerToConfigure((List)this.stylingConfig.get(this.stylerKeys.getValue()));
        }
        catch (Exception ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    @FXML
    private void chooseStyleOrCondition(ActionEvent event) {
        if (null == this.parameterizableCombo.getValue()) {
            this.parameterizableCombo.requestFocus();
            return;
        }
        try {
            this.currentParameterizable.set((Object)(this.parameterizableCombo.getValue() instanceof DocumentStyler ? (Parameterizable)this.parameterizableCombo.getValue() : ((Parameterizable)this.parameterizableCombo.getValue()).clone()));
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        if (this.currentParameterizable.get() instanceof DocumentSettings) {
            this.chooseOrAdd("documentsettings");
        }
        this.tableViewController.getParameters().clear();
        try {
            Parameterizable _st = (Parameterizable)this.parameterizableCombo.getValue();
            this.stylerHelp.setText(_st instanceof BaseStyler ? ((BaseStyler)_st).getHelp() : "condition to determine when to style or not");
            _st.getParameters().values().stream().forEach(p -> this.tableViewController.getParameters().add(new ParameterProps(p)));
            FXCollections.sort(this.tableViewController.getParameters());
        }
        catch (Exception ex) {
            ViewHelper.toError(ex, this.error);
        }
        this.showStylerHelp((Event)event);
    }

    @FXML
    private void clear(ActionEvent event) {
        this.tableViewController.getParameters().clear();
        this.parameterizableForClass.clear();
        this.stylingConfig.clear();
        this.defaults.clear();
        this.extraSettings.clear();
        this.processed.clear();
        this.commentsAfter.clear();
        this.commentsBefore.clear();
    }

    @FXML
    private void showConfig(ActionEvent event) {
        if ("".equals(this.stylerKeys.getValue()) || null == this.stylerKeys.getValue()) {
            this.stylerKeys.requestFocus();
            return;
        }
        try {
            this.tableViewController.getParameters().stream().filter(pp -> pp.getValue() != null && !"".equals(pp.getValue())).forEach(pp -> {
                Parameter p = (Parameter)((Parameterizable)this.currentParameterizable.get()).getParameters().get(pp.getKey());
                p.setValue(pp.getRawValue());
            });
            StringWriter sw = new StringWriter();
            ParamBindingService.getInstance().getFactory().getSerializer().serialize((Parameterizable)this.currentParameterizable.get(), (Writer)sw);
            this.tableViewController.getConfigString().setText(sw.toString());
        }
        catch (Exception ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    private void prepareAdd(Parameterizable p, List current) {
        if (!duplicatesAllowed.contains(p.getClass())) {
            Iterator it = current.iterator();
            while (it.hasNext()) {
                Object pz = it.next();
                if (!p.getClass().equals(pz.getClass())) continue;
                it.remove();
                break;
            }
        }
    }

    private boolean add(Parameterizable p) throws IOException {
        if ("".equals(this.stylerKeys.getValue())) {
            this.stylerKeys.requestFocus();
            return false;
        }
        String styleClass = (String)this.stylerKeys.getValue();
        if ("documentsettings".equals(styleClass) && !(p instanceof DocumentStyler)) {
            ViewHelper.notify("ok", styleClass, String.format("style class %s reserved for document settings, choose another", "documentsettings"));
            return false;
        }
        if (!this.stylingConfig.containsKey((Object)styleClass) && !"".equals(styleClass)) {
            this.stylingConfig.put((Object)styleClass, new ArrayList());
        }
        if (p instanceof BaseStyler) {
            if (ViewHelper.isCondition(styleClass, (List)this.stylingConfig.get((Object)styleClass))) {
                ViewHelper.notify("ok", styleClass, String.format("style class %s is for stylers, %s is a condition", styleClass, p.getClass().getSimpleName()));
                return false;
            }
            if (!"documentsettings".equals(styleClass) && p instanceof DocumentStyler) {
                ViewHelper.notify("ok", styleClass, String.format("style class should be %s for document settings", "documentsettings"));
                return false;
            }
            if (((BaseStyler)p).creates() && !((List)this.stylingConfig.get((Object)styleClass)).isEmpty()) {
                ViewHelper.notify("ok", "must be first", String.format("styler %s creates a report element, should be the first styler for a style class, you should probably reorder your stylers", p.getClass().getSimpleName()));
            }
            if (!this.tableViewController.getConfigString().getText().startsWith(this.currentParameterizable.getClass().getSimpleName() + ".")) {
                String cnd;
                this.prepareAdd(p, (List)this.stylingConfig.get((Object)styleClass));
                ((List)this.stylingConfig.get((Object)styleClass)).add((BaseStyler)p);
                if (!"".equals(p.getValue("conditions", String.class)) && null != (cnd = (String)((Object)p.getValue("conditions", String.class))) && !this.stylingConfig.containsKey((Object)cnd)) {
                    this.chooseOrAdd((String)((Object)p.getValue("conditions", String.class)));
                    this.parameterizableCombo.getSelectionModel().clearSelection();
                    ViewHelper.notify("add " + (String)((Object)p.getValue("conditions", String.class)), "warning", String.format("condition %s is missing", p.getValue("conditions", String.class)));
                }
            }
        } else {
            if (ViewHelper.isStyler(styleClass, (List)this.stylingConfig.get((Object)styleClass))) {
                ViewHelper.notify("ok", styleClass, String.format("style class %s is for conditions, %s is a styler", styleClass, p.getClass().getSimpleName()));
                return false;
            }
            if (!this.tableViewController.getConfigString().getText().startsWith(this.currentParameterizable.getClass().getSimpleName() + ".")) {
                this.prepareAdd(p, (List)this.stylingConfig.get((Object)styleClass));
                ((List)this.stylingConfig.get((Object)styleClass)).add((StylingCondition)p);
            }
            this.stylingConfig.entrySet().stream().forEach(stylers -> ((List)stylers.getValue()).stream().forEach(bs -> bs.getSettings().put(styleClass, p.getClass().getSimpleName())));
        }
        return true;
    }

    private void selectInCombo(Parameterizable par) {
        this.tableViewController.getParameters().clear();
        this.currentParameterizable.set((Object)par);
        if (par != null) {
            for (int j = 0; j < this.parameterizableCombo.getItems().size(); ++j) {
                if (!((Parameterizable)this.parameterizableCombo.getItems().get(j)).getClass().equals(par.getClass())) continue;
                this.parameterizableCombo.getSelectionModel().select(j);
                break;
            }
            this.stylerHelp.setText(this.currentParameterizable instanceof BaseStyler ? ((BaseStyler)this.currentParameterizable).getHelp() : "condition to determine when to style or not");
            for (Parameter p : ((Parameterizable)this.currentParameterizable.get()).getParameters().values()) {
                this.tableViewController.getParameters().add(new ParameterProps(p));
            }
            this.showConfig(null);
        }
    }

    private void pickStylerToConfigure(List<Parameterizable> stylers) {
        if (stylers.size() == 1) {
            this.selectInCombo(stylers.get(0));
            return;
        }
        if (stylers.isEmpty()) {
            this.selectInCombo(null);
            return;
        }
        ArrayList pw = new ArrayList(stylers.size());
        stylers.stream().forEach(p -> pw.add(new ParameterizableWrapper((Parameterizable)p)));
        ChoiceDialog dialog = new ChoiceDialog(pw.get(0), pw);
        ButtonType bt = new ButtonType("choose", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().clear();
        dialog.getDialogPane().getButtonTypes().add((Object)bt);
        dialog.setTitle("Please choose");
        dialog.setHeaderText(null);
        dialog.setResizable(true);
        dialog.setContentText("choose the styler or condition you want to configure");
        Optional choice = dialog.showAndWait();
        if (choice.isPresent()) {
            this.selectInCombo(((ParameterizableWrapper)choice.get()).p);
        }
    }

    private String toConfigString(String clazz, List<? extends Parameterizable> sp) throws IOException {
        ParsingProperties p = new ParsingProperties((EnhancedMap)new Settings());
        this.toConfigString(clazz, sp, p);
        StringWriter sw = new StringWriter(p.size() * 30);
        SettingsBindingService.getInstance().getFactory().getSerializer().serialize((EnhancedMap)p, (Writer)sw);
        return sw.toString();
    }

    private void stripPreAndPost(String clazz, List<? extends Parameterizable> sp) {
        if (!"PRESTYLERS".equals(clazz) && !"POSTSTYLERS".equals(clazz)) {
            if (this.stylingConfig.containsKey((Object)"PRESTYLERS")) {
                ((List)this.stylingConfig.get((Object)"PRESTYLERS")).stream().forEach(p -> sp.remove(p));
            }
            if (this.stylingConfig.containsKey((Object)"POSTSTYLERS")) {
                ((List)this.stylingConfig.get((Object)"POSTSTYLERS")).stream().forEach(p -> sp.remove(p));
            }
        }
    }

    private void toConfigString(String clazz, List<? extends Parameterizable> sp, ParsingProperties eh) throws IOException {
        this.stripPreAndPost(clazz, sp);
        ArrayList<String> pp = new ArrayList<String>(sp.size());
        for (Parameterizable parameterizable : sp) {
            StringWriter sw = new StringWriter();
            ParamBindingService.getInstance().getFactory().getSerializer().serialize(parameterizable, (Writer)sw);
            pp.add(sw.toString());
        }
        String[] toArray = (String[])ArrayHelper.toArray(pp);
        eh.put(clazz, toArray == null ? EMPTY : toArray);
    }

    private void printComment(String key, ParsingProperties eh) {
        if (key != null && this.commentsBefore.containsKey(key)) {
            this.commentsBefore.get(key).stream().forEach(s -> eh.addCommentBeforeKey(key, s));
        } else {
            this.commentsAfter.stream().forEach(s -> eh.addTrailingComment(s));
        }
    }

    private EnhancedMap buildSettings() throws IOException {
        ParsingProperties eh = new ParsingProperties((EnhancedMap)new SortedProperties((EnhancedMap)new Settings()));
        this.stylesheet.getText().clear();
        this.defaults.stream().forEach(def -> {
            this.printComment(def.clazz + "." + def.key + '.' + def.suffix.name(), eh);
            eh.put(def.clazz + "." + def.key + '.' + def.suffix.name(), def.value);
        });
        for (Map.Entry e2 : this.stylingConfig.entrySet()) {
            this.printComment((String)e2.getKey(), eh);
            this.toConfigString((String)e2.getKey(), (List)e2.getValue(), eh);
        }
        this.extraSettings.entrySet().stream().map(e -> {
            this.printComment((String)e.getKey(), eh);
            return e;
        }).forEach(e -> eh.put((String)e.getKey(), (String)e.getValue()));
        return eh;
    }

    @FXML
    private void buildStylesheet(ActionEvent event) {
        try {
            EnhancedMap eh = this.buildSettings();
            StringWriter sw = new StringWriter(eh.size() * 30);
            SettingsBindingService.getInstance().getFactory().getSerializer().serialize(eh, (Writer)sw);
            this.stylesheet.getText().appendText(sw.toString());
            this.styleTab.getTabPane().getSelectionModel().select((Object)this.styleTab);
        }
        catch (Exception ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    @FXML
    private void toConfig(ActionEvent event) {
        try {
            if (this.currentParameterizable == null) {
                throw new VectorPrintRuntimeException("first choose a style or condition using configure");
            }
            this.showConfig(event);
            this.add((Parameterizable)this.currentParameterizable.get());
        }
        catch (Exception ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    @FXML
    private void showStylerHelp(Event event) {
        this.stylerHelp.setText(this.help((Parameterizable)this.parameterizableCombo.getValue()));
        this.stylerHelp.setTooltip(ViewHelper.tip(this.help((Parameterizable)this.parameterizableCombo.getValue())));
    }

    private String help(Parameterizable p) {
        return p != null ? (p instanceof BaseStyler ? ((BaseStyler)p).getHelp() : ((StylingCondition)p).getHelp()) : "";
    }

    @FXML
    private void addFromClassPath() {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            List l = ViewHelper.prepareFC("add jar", "Jar files (*.jar)", "*.jar", "*.JAR", "*.Jar").showOpenMultipleDialog(null);
            if (l != null) {
                URL[] u = new URL[l.size()];
                int i = -1;
                for (File f : l) {
                    u[++i] = f.toURI().toURL();
                }
                URLClassLoader urlClassLoader = new URLClassLoader(u, orig);
                Thread.currentThread().setContextClassLoader(urlClassLoader);
                ArrayList sorted = new ArrayList(Help.getStylersAndConditions());
                Collections.sort(sorted, PARAMETERIZABLE_COMPARATOR);
                this.parameterizableCombo.setItems(FXCollections.observableArrayList(sorted));
            }
        }
        catch (NoClassDefFoundError error) {
            Thread.currentThread().setContextClassLoader(orig);
            ViewHelper.toError(error, this.error);
        }
        catch (Exception exception) {
            Thread.currentThread().setContextClassLoader(orig);
            ViewHelper.toError(exception, this.error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.tableViewController.getCurrentParameterizable().bind(this.currentParameterizable);
            this.tableViewController.setDefaults(this.defaults);
            this.tableViewController.setError(this.error);
            this.tableViewController.setHelp(this.help);
            this.tableViewController.setHelpTab(this.helpTab);
            this.tableViewController.setPdf1a(this.pdf1a);
            this.tableViewController.setToc(this.toc);
            this.initFactories();
            ArrayList sorted = new ArrayList(Help.getStylersAndConditions());
            Collections.sort(sorted, PARAMETERIZABLE_COMPARATOR);
            Set<Class<? extends Parameterizable>> set = duplicatesAllowed;
            synchronized (set) {
                if (duplicatesAllowed.isEmpty()) {
                    duplicatesAllowed.add(Padding.class);
                    duplicatesAllowed.add(NewLine.class);
                    duplicatesAllowed.add(NewPage.class);
                    sorted.stream().filter(pz -> pz instanceof Advanced).forEach(pz -> duplicatesAllowed.add(pz.getClass()));
                }
            }
            this.parameterizableCombo.setCellFactory(p -> new ListCell<Parameterizable>(){

                protected void updateItem(Parameterizable t, boolean bln) {
                    super.updateItem((Object)t, bln);
                    this.setText(t == null ? "" : t.getClass().getSimpleName());
                    this.setTooltip(t != null ? ViewHelper.tip(Controller.this.help(t)) : null);
                }
            });
            this.parameterizableCombo.setItems(FXCollections.observableArrayList(sorted));
            this.stylerKeys.setPromptText("required!");
            this.stylerKeys.setItems(this.styleClasses);
            this.stylerKeys.setCellFactory(p -> new ListCell<String>(){

                protected void updateItem(String t, boolean bln) {
                    super.updateItem((Object)t, bln);
                    if (t != null) {
                        this.setText(t);
                        Tooltip tip = ViewHelper.tip("config....");
                        if (Controller.this.stylingConfig.containsKey((Object)t)) {
                            tip.addEventHandler(WindowEvent.WINDOW_SHOWING, event -> {
                                try {
                                    tip.setText(Controller.this.toConfigString(t, (List)Controller.this.stylingConfig.get((Object)t)));
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                        }
                        this.setTooltip(tip);
                    }
                }
            });
            this.stylerKeys.valueProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null && !"".equals(newValue) && !this.stylingConfig.containsKey(newValue)) {
                    this.stylingConfig.put(newValue, new ArrayList());
                }
            });
            this.styleClassTableController.setCStylerKeysFactory((Callback<ListView<String>, ListCell<String>>)this.stylerKeys.getCellFactory());
            this.styleClassTableController.setStylerKeyItems(this.styleClasses);
            this.styleClassTableController.setStylingConfig(this.stylingConfig);
            this.stylerKeys.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    Controller.this.styleClassTableController.select(newValue);
                }
            });
            ByteArrayOutputStream bo = new ByteArrayOutputStream(4096);
            Help.printHelp((PrintStream)new PrintStream(bo));
            this.help.getText().setText(bo.toString());
            bo.reset();
            this.datamappingxsd.loadXml(DatamappingHelper.class.getResourceAsStream("/xsd/DataMappingConfig.xsd"));
            this.settingsxsd.loadXml(DatamappingHelper.class.getResourceAsStream("/xsd/Settings.xsd"));
            this.controller = new SwingController();
            SwingViewBuilder factory = new SwingViewBuilder(this.controller);
            JPanel viewerComponentPanel = factory.buildViewerPanel();
            this.controller.getDocumentViewController().setAnnotationCallback((AnnotationCallback)new MyAnnotationCallback(this.controller.getDocumentViewController()));
            this.pdfpane.setContent((JComponent)viewerComponentPanel);
        }
        catch (NoClassDefFoundError ex) {
            Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
            throw new VectorPrintRuntimeException((Throwable)ex);
        }
        catch (Exception ex) {
            Logger.getLogger(Controller.class.getName()).log(Level.SEVERE, null, ex);
            throw new VectorPrintRuntimeException((Throwable)ex);
        }
    }

    @FXML
    private void save(ActionEvent event) {
        try {
            FileChooser fc = new FileChooser();
            fc.setTitle("save stylesheet");
            File f = fc.showSaveDialog(null);
            if (f != null) {
                Files.write(f.toPath(), this.stylesheet.getText().getText().getBytes(), new OpenOption[0]);
            }
        }
        catch (Exception ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    @FXML
    private void testStylesheet(ActionEvent event) {
        try {
            StylesheetTester stylesheetTester = new StylesheetTester(this);
            stylesheetTester.testStyleSheet(this.stylesheet.getText().getText());
        }
        catch (Exception ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    @FXML
    private void changeSyntax(ActionEvent event) {
        com.vectorprint.configuration.binding.settings.SpecificClassValidator.setClazz((Class)((Class)this.settingsfactory.getValue()));
        SpecificClassValidator.setClazz((Class)((Class)this.paramfactory.getValue()));
    }

    @FXML
    private void validateDataMappingXml(ActionEvent event) {
        try {
            try {
                DatamappingHelper.validateXml((URL)BindingHelper.URL_PARSER.convert(this.xmlconfig.getText()));
                ViewHelper.notify("ok", "valid xml", "valid xml");
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("wrong url, trying xml directly");
                malformedURLException.printStackTrace();
                DatamappingHelper.validateXml((String)this.xmlconfig.getText());
            }
        }
        catch (SAXException ex) {
            ViewHelper.toError(ex, this.error);
        }
        catch (IOException ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    @FXML
    private void validateSettingsXml(ActionEvent event) {
        try {
            try {
                SettingsXMLHelper.validateXml((URL)BindingHelper.URL_PARSER.convert(this.xmlsettings.getText()));
                ViewHelper.notify("ok", "valid xml", "valid xml");
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("wrong url, trying xml directly");
                malformedURLException.printStackTrace();
                SettingsXMLHelper.validateXml((String)this.xmlsettings.getText());
            }
        }
        catch (SAXException ex) {
            ViewHelper.toError(ex, this.error);
        }
        catch (IOException ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    @FXML
    private void checkUrlConfig(ActionEvent event) {
        try {
            BindingHelper.URL_PARSER.convert(this.xmlconfig.getText());
            this.extraSettings.put("datamappingxml", this.xmlconfig.getText());
        }
        catch (VectorPrintRuntimeException ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    @FXML
    private void checkUrlSettings(ActionEvent event) {
        try {
            BindingHelper.URL_PARSER.convert(this.xmlsettings.getText());
        }
        catch (VectorPrintRuntimeException ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    private void importStyle(ParsingProperties settings) throws DocumentException, VectorPrintException {
        this.clear(null);
        Boolean preAndPost = settings.getBooleanProperty(Boolean.valueOf(true), new String[]{"preandpoststyle"});
        settings.put("preandpoststyle", Boolean.FALSE.toString());
        DefaultStylerFactory sf = new DefaultStylerFactory();
        StylerFactoryHelper.SETTINGS_ANNOTATION_PROCESSOR.initSettings((Object)sf, (EnhancedMap)settings);
        Document d = new Document();
        PdfWriter w = PdfWriter.getInstance((Document)d, (OutputStream)new ByteArrayOutputStream(0));
        w.setPageEvent((PdfPageEvent)new EventHelper());
        sf.setDocument(d, w);
        for (Map.Entry<String, String> e2 : settings.entrySet()) {
            this.commentsBefore.put((String)e2.getKey(), settings.getCommentBeforeKey((String)e2.getKey()));
            if ("documentsettings".equals(e2.getKey())) {
                this.stylingConfig.put((Object)e2.getKey(), new ArrayList(1));
                ((List)this.stylingConfig.get((Object)e2.getKey())).add(sf.getDocumentStyler());
                this.pdf1a.setSelected(((Boolean)sf.getDocumentStyler().getValue("pdfa", Boolean.class)).booleanValue());
                this.toc.setSelected(((Boolean)sf.getDocumentStyler().getValue("toc", Boolean.class)).booleanValue());
                continue;
            }
            if (ViewHelper.isStyler(e2.getKey(), (EnhancedMap)settings)) {
                this.stylingConfig.put((Object)e2.getKey(), new ArrayList(3));
                try {
                    List l = sf.getStylers(new String[]{e2.getKey()});
                    ((List)this.stylingConfig.get((Object)e2.getKey())).addAll(l);
                    this.getConditions(l);
                    this.getDefaults(l, (EnhancedMap)settings);
                }
                catch (VectorPrintException ex) {
                    ViewHelper.toError(ex, this.error);
                }
                continue;
            }
            if (ViewHelper.isCondition(e2.getKey(), (EnhancedMap)settings)) continue;
            if ("preandpoststyle".equals(e2.getKey())) {
                this.prepost.setSelected(preAndPost.booleanValue());
                this.extraSettings.put(e2.getKey(), preAndPost.toString());
                continue;
            }
            if ("debug".equals(e2.getKey())) {
                this.debug.setSelected(Boolean.valueOf(((String[])e2.getValue())[0]).booleanValue());
            } else if ("printfooter".equals(e2.getKey())) {
                this.footer.setSelected(Boolean.valueOf(((String[])e2.getValue())[0]).booleanValue());
            }
            this.extraSettings.put(e2.getKey(), ((String[])e2.getValue())[0]);
        }
        Iterator<Map.Entry<String, String>> it = this.extraSettings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e2;
            e2 = it.next();
            if (!this.processed.contains(e2.getKey())) continue;
            it.remove();
        }
        settings.entrySet().stream().forEach(e -> {
            if (ViewHelper.isCondition((String)e.getKey(), (EnhancedMap)settings)) {
                List conditions;
                Logger.getLogger(Controller.class.getName()).warning(String.format("unreferenced conditions for key: %s", e.getKey()));
                try {
                    conditions = sf.getConditions((String)e.getKey());
                }
                catch (VectorPrintException ex) {
                    throw new VectorPrintRuntimeException((Throwable)ex);
                }
                this.stylingConfig.put(e.getKey(), new ArrayList(conditions.size()));
                ((List)this.stylingConfig.get(e.getKey())).addAll(conditions);
            }
        });
        this.commentsAfter.addAll(settings.getTrailingComment());
        ViewHelper.notify("ok", "import complete", "you can now adapt and (re)build your stylesheet");
    }

    @FXML
    private void importStyle(ActionEvent event) {
        try {
            FileChooser fc = new FileChooser();
            fc.setTitle("import stylesheet");
            File f = fc.showOpenDialog(null);
            if (f != null && f.canRead()) {
                this.importStyle(new ParsingProperties((EnhancedMap)new SortedProperties((EnhancedMap)new Settings()), new String[]{f.getPath()}));
            }
        }
        catch (Exception ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    @FXML
    private void importCss(ActionEvent event) {
        try {
            File f = ViewHelper.prepareFC("import css", "Css files (*.css)", "*.css", "*.CSS", "*.Css").showOpenDialog(null);
            if (f != null && f.canRead()) {
                System.setProperty("org.w3c.css.sac.parser", SACParser.class.getName());
                ByteArrayOutputStream bo = new ByteArrayOutputStream(2048);
                CssTransformer.transform((InputStream)new FileInputStream(f), (OutputStream)bo, (boolean)this.cssvalidate.isSelected());
                this.importStyle(new ParsingProperties((EnhancedMap)new SortedProperties((EnhancedMap)new Settings()), new Reader[]{new StringReader(bo.toString())}));
            }
        }
        catch (Exception ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    @FXML
    private void showPdf(ActionEvent event) {
        try {
            File f = ViewHelper.prepareFC("open pdf", "Pdf files (*.pdf)", "*.pdf", "*.PDF", "*.Pdf").showOpenDialog(null);
            if (f != null && f.canRead()) {
                this.openPdf(new FileInputStream(f), f.getPath());
            }
        }
        catch (Exception ex) {
            ViewHelper.toError(ex, this.error);
        }
    }

    void openPdf(InputStream in, String description) {
        this.controller.openDocument(in, description, null);
        this.pdftab.getTabPane().getSelectionModel().select((Object)this.pdftab);
    }

    private void getConditions(Collection<? extends BaseStyler> l) {
        l.stream().forEach(bs -> {
            String scKey = (String)((Object)bs.getValue("conditions", String.class));
            if (bs.getConditions() != null && !bs.getConditions().isEmpty() && !this.processed.contains(scKey)) {
                for (StylingCondition sc : bs.getConditions()) {
                    if ("not from configuration".equals(sc.getConfigKey()) || !scKey.equals(sc.getConfigKey())) continue;
                    if (this.stylingConfig.get((Object)sc.getConfigKey()) == null) {
                        this.stylingConfig.put((Object)sc.getConfigKey(), new ArrayList(bs.getConditions().size()));
                    }
                    ((List)this.stylingConfig.get((Object)sc.getConfigKey())).add(sc);
                }
                this.getDefaults(bs.getConditions(), ((AbstractStyler)bs).getSettings());
                this.processed.add(scKey);
            }
        });
    }

    private void getDefaults(Collection<? extends Parameterizable> l, EnhancedMap settings) {
        l.stream().forEach(pz -> pz.getParameters().values().stream().forEach(p -> {
            String key = ParameterHelper.findKey((String)p.getKey(), pz.getClass(), (EnhancedMap)settings, (ParameterHelper.SUFFIX)ParameterHelper.SUFFIX.set_default);
            if (key != null) {
                DefaultValue defaultValue = new DefaultValue(pz.getClass().getSimpleName(), p.getKey(), ((String[])settings.get((Object)key))[0], ParameterHelper.SUFFIX.set_default);
                this.defaults.remove(defaultValue);
                this.defaults.add(defaultValue);
                this.processed.add(pz.getClass().getSimpleName() + "." + p.getKey() + '.' + ParameterHelper.SUFFIX.set_default);
            }
        }));
    }

    @FXML
    private void quit(ActionEvent event) {
        Platform.exit();
    }

    @FXML
    private void toggleFooter(ActionEvent event) {
        this.extraSettings.put("printfooter", String.valueOf(this.footer.isSelected()));
        this.stylerHelp.setText("printfooter=" + String.valueOf(this.footer.isSelected()));
    }

    @FXML
    private void toggleDebug(ActionEvent event) {
        this.extraSettings.put("debug", String.valueOf(this.debug.isSelected()));
        this.stylerHelp.setText("debug=" + String.valueOf(this.debug.isSelected()));
    }

    @FXML
    private void togglePrePost(ActionEvent event) {
        this.extraSettings.put("preandpoststyle", String.valueOf(this.prepost.isSelected()));
        this.stylerHelp.setText("preandpoststyle=" + String.valueOf(this.prepost.isSelected()));
    }

    @FXML
    private void showParHelp(Event event) {
        KeyCode kc;
        if (event instanceof KeyEvent && !KeyCode.ENTER.equals((Object)(kc = ((KeyEvent)event).getCode()))) {
            return;
        }
        if (this.parameterizableCombo.getValue() != null) {
            this.help.searchArea(((Parameterizable)this.parameterizableCombo.getValue()).getClass().getSimpleName() + ": ", false);
            this.helpTab.getTabPane().getSelectionModel().select((Object)this.helpTab);
            this.help.requestFocus();
        } else {
            this.parameterizableCombo.requestFocus();
        }
    }

    private void initFactories() throws InstantiationException, IllegalAccessException {
        this.settingsfactory.setItems(FXCollections.observableArrayList((Collection)SettingsBindingService.getInstance().getValidFactories()));
        this.paramfactory.setItems(FXCollections.observableArrayList((Collection)ParamBindingService.getInstance().getValidFactories()));
        Class<?> aClass = SettingsBindingService.getInstance().getFactory().getClass();
        this.settingsfactory.getSelectionModel().select(aClass);
        Class<?> aClass1 = ParamBindingService.getInstance().getFactory().getClass();
        this.paramfactory.getSelectionModel().select(aClass1);
    }

    private static class ParameterizableWrapper {
        private final Parameterizable p;

        public ParameterizableWrapper(Parameterizable p) {
            this.p = p;
        }

        public String toString() {
            return this.p.getClass().getSimpleName();
        }
    }

    private static class ParameterizableComparator
    implements Comparator<Parameterizable> {
        private ParameterizableComparator() {
        }

        @Override
        public int compare(Parameterizable o1, Parameterizable o2) {
            if (o1 instanceof BaseStyler && o2 instanceof StylingCondition) {
                return 1;
            }
            if (o1 instanceof StylingCondition && o2 instanceof BaseStyler) {
                return -1;
            }
            return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
        }
    }
}

