/*
 * Decompiled with CFR 0.152.
 */
package com.vectorprint.vectorprintreportgui;

import com.vectorprint.VectorPrintRuntimeException;
import com.vectorprint.configuration.parameters.Parameterizable;
import com.vectorprint.report.itext.style.BaseStyler;
import com.vectorprint.vectorprintreportgui.ViewHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class StyleClassTableController
implements Initializable {
    private final ObservableList<Parameterizable> parameterizableForClass = FXCollections.observableArrayList(new ArrayList(3));
    private ObservableMap<String, List<Parameterizable>> stylingConfig;
    @FXML
    private ComboBox<String> stylerKeysCopy;
    @FXML
    private TableView<Parameterizable> parameterizableTable;
    @FXML
    private TableColumn<Parameterizable, Parameterizable> sUpDown;
    @FXML
    private TableColumn<Parameterizable, Parameterizable> rm;
    @FXML
    private TableColumn<Parameterizable, String> sHelp;

    @FXML
    private void showStylers(Event event) {
        if (this.stylerKeysCopy.getValue() != null && this.stylingConfig.containsKey(this.stylerKeysCopy.getValue())) {
            this.parameterizableForClass.clear();
            ((List)this.stylingConfig.get(this.stylerKeysCopy.getValue())).stream().forEach(bs -> this.parameterizableForClass.add(bs));
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.parameterizableTable.setItems(this.parameterizableForClass);
            this.sHelp.setCellValueFactory(p -> new ReadOnlyObjectWrapper((Object)(((Parameterizable)p.getValue()).getClass().getSimpleName() + ": " + ViewHelper.helpFor((Parameterizable)p.getValue()))));
            this.sHelp.setCellFactory(p -> new TableCell<Parameterizable, String>(){

                protected void updateItem(String t, boolean bln) {
                    super.updateItem((Object)t, bln);
                    this.setText(t);
                    if (t != null) {
                        this.setTooltip(ViewHelper.tip(t));
                    }
                }
            });
            this.sUpDown.setCellValueFactory(p -> new ReadOnlyObjectWrapper(p.getValue()));
            this.sUpDown.setCellFactory(p -> new TableCell<Parameterizable, Parameterizable>(){

                protected void updateItem(Parameterizable bs, boolean bln) {
                    super.updateItem((Object)bs, bln);
                    this.setGraphic(null);
                    if (bs == null || this.getTableRow() == null) {
                        return;
                    }
                    Integer t = this.getTableRow().getIndex();
                    Button b = new Button("/\\");
                    b.setTooltip(ViewHelper.tip("move styler up"));
                    b.setOnAction(e -> {
                        if (t == null || StyleClassTableController.this.parameterizableForClass == null) {
                            return;
                        }
                        if (t > 0) {
                            Parameterizable toMove = (Parameterizable)StyleClassTableController.this.parameterizableForClass.get(t.intValue());
                            Parameterizable sp = (Parameterizable)StyleClassTableController.this.parameterizableForClass.set(t - 1, (Object)toMove);
                            StyleClassTableController.this.parameterizableForClass.set(t.intValue(), (Object)sp);
                            ((List)StyleClassTableController.this.stylingConfig.get(StyleClassTableController.this.stylerKeysCopy.getValue())).clear();
                            StyleClassTableController.this.parameterizableForClass.forEach(p -> ((List)StyleClassTableController.this.stylingConfig.get(StyleClassTableController.this.stylerKeysCopy.getValue())).add((BaseStyler)p));
                        }
                    });
                    Button bd = new Button("\\/");
                    bd.setLayoutX(35.0);
                    bd.setTooltip(ViewHelper.tip("move styler down"));
                    bd.setOnAction(e -> {
                        if (t == null || StyleClassTableController.this.parameterizableForClass == null) {
                            return;
                        }
                        if (t < StyleClassTableController.this.parameterizableForClass.size() - 1) {
                            Parameterizable toMove = (Parameterizable)StyleClassTableController.this.parameterizableForClass.get(t.intValue());
                            Parameterizable sp = (Parameterizable)StyleClassTableController.this.parameterizableForClass.set(t + 1, (Object)toMove);
                            StyleClassTableController.this.parameterizableForClass.set(t.intValue(), (Object)sp);
                            ((List)StyleClassTableController.this.stylingConfig.get(StyleClassTableController.this.stylerKeysCopy.getValue())).clear();
                            ((List)StyleClassTableController.this.stylingConfig.get(StyleClassTableController.this.stylerKeysCopy.getValue())).addAll(StyleClassTableController.this.parameterizableForClass);
                        }
                    });
                    this.setGraphic((Node)new Group(new Node[]{b, bd}));
                }
            });
            this.rm.setCellValueFactory(p -> new ReadOnlyObjectWrapper(p.getValue()));
            this.rm.setCellFactory(p -> new TableCell<Parameterizable, Parameterizable>(){

                protected void updateItem(Parameterizable bs, boolean bln) {
                    super.updateItem((Object)bs, bln);
                    this.setGraphic(null);
                    if (bs == null || this.getTableRow() == null) {
                        return;
                    }
                    Integer t = this.getTableRow().getIndex();
                    Button b = new Button("X");
                    b.setTooltip(ViewHelper.tip("remove styler"));
                    b.setOnAction(e -> {
                        String clazz;
                        if (t == null) {
                            return;
                        }
                        Parameterizable bs1 = (Parameterizable)StyleClassTableController.this.parameterizableForClass.get(t.intValue());
                        boolean removed = StyleClassTableController.this.parameterizableForClass.remove((Object)bs1);
                        if (removed) {
                            ((List)StyleClassTableController.this.stylingConfig.get(StyleClassTableController.this.stylerKeysCopy.getValue())).clear();
                            ((List)StyleClassTableController.this.stylingConfig.get(StyleClassTableController.this.stylerKeysCopy.getValue())).addAll(StyleClassTableController.this.parameterizableForClass);
                        }
                        if (StyleClassTableController.this.parameterizableForClass.isEmpty() && (clazz = (String)StyleClassTableController.this.stylerKeysCopy.getValue()) != null) {
                            System.out.println("removed config: " + StyleClassTableController.this.stylingConfig.remove((Object)clazz));
                        }
                    });
                    this.setGraphic((Node)b);
                }
            });
        }
        catch (NoClassDefFoundError ex) {
            Logger.getLogger(StyleClassTableController.class.getName()).log(Level.SEVERE, null, ex);
            throw new VectorPrintRuntimeException((Throwable)ex);
        }
        catch (Exception ex) {
            Logger.getLogger(StyleClassTableController.class.getName()).log(Level.SEVERE, null, ex);
            throw new VectorPrintRuntimeException((Throwable)ex);
        }
    }

    void setStylingConfig(ObservableMap<String, List<Parameterizable>> stylingConfig) {
        this.stylingConfig = stylingConfig;
    }

    void setStylerKeyItems(ObservableList<String> items) {
        this.stylerKeysCopy.setItems(items);
    }

    void select(String key) {
        this.stylerKeysCopy.getSelectionModel().select((Object)key);
    }

    void setCStylerKeysFactory(Callback<ListView<String>, ListCell<String>> factory) {
        this.stylerKeysCopy.setCellFactory(factory);
    }
}

