/*
 * Decompiled with CFR 0.152.
 */
package com.vectorprint.vectorprintreportgui;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.Section;
import com.itextpdf.text.TextElementArray;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.vectorprint.VectorPrintException;
import com.vectorprint.configuration.EnhancedMap;
import com.vectorprint.configuration.Settings;
import com.vectorprint.configuration.decoration.CachingProperties;
import com.vectorprint.configuration.decoration.ParsingProperties;
import com.vectorprint.report.data.ReportDataHolderImpl;
import com.vectorprint.report.itext.BaseReportGenerator;
import com.vectorprint.report.itext.DefaultElementProducer;
import com.vectorprint.report.itext.ElementProducer;
import com.vectorprint.report.itext.EventHelper;
import com.vectorprint.report.itext.ItextHelper;
import com.vectorprint.report.itext.style.BaseStyler;
import com.vectorprint.report.itext.style.stylers.Barcode;
import com.vectorprint.report.itext.style.stylers.Chart;
import com.vectorprint.report.itext.style.stylers.ImageAlign;
import com.vectorprint.report.itext.style.stylers.SVG;
import com.vectorprint.report.itext.style.stylers.SimpleColumns;
import com.vectorprint.report.itext.style.stylers.Table;
import com.vectorprint.report.running.ReportRunner;
import com.vectorprint.vectorprintreportgui.Controller;
import com.vectorprint.vectorprintreportgui.ViewHelper;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultXYDataset;

public class StylesheetTester
extends BaseReportGenerator<ReportDataHolderImpl> {
    private final Controller controller;
    private static final String EXAMPLE_STYLING_OF_ = "example styling of ";
    private static final String TRYING_TO_SHOW_THE_EFFECT_OF_S_ON_S_ = "Trying to apply style %s (%s) to %s.";
    private static final String END_EFFECT_OF_S_ON_S_ = "End showing applied style.";
    private static final String SHOWING_EFFECT_OF_S_ON_S_ = "Showing style (%s) applied to %s:";

    public StylesheetTester(Controller controller) throws VectorPrintException {
        super(new EventHelper(), (ElementProducer)new DefaultElementProducer());
        this.controller = controller;
    }

    public StylesheetTester() throws VectorPrintException {
        super(new EventHelper(), (ElementProducer)new DefaultElementProducer());
        this.controller = null;
    }

    public void testStyleSheet(String stylesheet) throws Exception {
        CachingProperties settings = new CachingProperties((EnhancedMap)new ParsingProperties((EnhancedMap)new Settings(), new Reader[]{new StringReader(stylesheet)}));
        settings.put("reportclass", ((Object)((Object)this)).getClass().getName());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new ReportRunner((EnhancedMap)settings).buildReport(null, (OutputStream)out);
        this.controller.openPdf(new ByteArrayInputStream(out.toByteArray()), "test stylesheet in pdf");
    }

    protected void createReportBody(Document document, ReportDataHolderImpl data, PdfWriter writer) throws DocumentException, VectorPrintException {
        Object[] setting;
        Object[] setting2;
        document.add((Element)new Paragraph("In this pdf you can see how your document will look like using stylesheet you built. If you want to see debugging info in this pdf, just put\"debug=true\" in the stylesheet."));
        if (this.getSettings().containsKey((Object)"PRESTYLERS")) {
            setting2 = this.getSettings().getStringProperties(null, new String[]{"PRESTYLERS"});
            this.printExplanation(String.format("styles applied before configured styles: %s", Arrays.toString(setting2)));
        }
        if (this.getSettings().containsKey((Object)"POSTSTYLERS")) {
            setting2 = this.getSettings().getStringProperties(null, new String[]{"POSTSTYLERS"});
            this.printExplanation(String.format("styles applied after configured styles: %s", Arrays.toString(setting2)));
        }
        if (this.getSettings().containsKey((Object)"PAGESTYLERS")) {
            setting2 = this.getSettings().getStringProperties(null, new String[]{"PAGESTYLERS"});
            this.printExplanation(String.format("styles applied on every page: %s", Arrays.toString(setting2)));
        }
        for (Map.Entry e : this.getSettings().entrySet()) {
            if (!ViewHelper.isCondition((String)e.getKey(), this.getSettings())) continue;
            setting = (String[])e.getValue();
            this.printExplanation(String.format("active conditions for %s: %s", e.getKey(), Arrays.toString(setting)));
        }
        this.newLine(3);
        for (Map.Entry e : this.getSettings().entrySet()) {
            if ("PRESTYLERS".equals(e.getKey()) || "POSTSTYLERS".equals(e.getKey()) || "documentsettings".equals(e.getKey()) || !ViewHelper.isStyler((String)e.getKey(), this.getSettings())) continue;
            setting = (String[])e.getValue();
            List stylers = this.getStylers(new String[]{(String)e.getKey()});
            BaseStyler first = (BaseStyler)stylers.get(0);
            try {
                if (!first.creates()) {
                    this.printExplanation(String.format(TRYING_TO_SHOW_THE_EFFECT_OF_S_ON_S_, e.getKey(), Arrays.toString(setting), first.getSupportedClasses()));
                    for (Class clazz : first.getSupportedClasses()) {
                        Element created;
                        List<BaseStyler> filter;
                        if (!Modifier.isAbstract(clazz.getModifiers())) {
                            if (Rectangle.class.equals((Object)clazz)) {
                                Rectangle rectangle = new Rectangle(ItextHelper.mmToPts((float)30.0f), ItextHelper.mmToPts((float)30.0f));
                                filter = StylesheetTester.filter(stylers, rectangle, null);
                                if (filter.isEmpty()) continue;
                                this.printExplanation(String.format(SHOWING_EFFECT_OF_S_ON_S_, StylesheetTester.print(filter), Rectangle.class.getSimpleName()));
                                document.add((Element)this.getStyleHelper().style((Object)rectangle, null, (Collection)stylers));
                                this.printExplanation(END_EFFECT_OF_S_ON_S_);
                                continue;
                            }
                            if (first instanceof ImageAlign) {
                                BufferedImage read = ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream("/testingrecources/pointer.png"));
                                com.itextpdf.text.Image img = com.itextpdf.text.Image.getInstance((Image)read, null);
                                PdfPTable pt = new PdfPTable(1);
                                PdfPCell cell = new PdfPCell();
                                cell.addElement((Element)img);
                                cell.setBorder(15);
                                cell.setBorderColor(BaseColor.BLACK);
                                cell.setBorderWidth(5.0f);
                                pt.addCell((PdfPCell)this.getStyleHelper().style((Object)cell, (Object)img, (Collection)stylers));
                                List<BaseStyler> filter2 = StylesheetTester.filter(stylers, PdfPCell.class, img);
                                this.printExplanation(String.format(SHOWING_EFFECT_OF_S_ON_S_, StylesheetTester.print(filter2), PdfPCell.class.getSimpleName()));
                                document.add((Element)pt);
                                this.printExplanation(END_EFFECT_OF_S_ON_S_);
                                continue;
                            }
                            if (Section.class.isAssignableFrom(clazz)) {
                                List<BaseStyler> filter3 = StylesheetTester.filter(stylers, Section.class, EXAMPLE_STYLING_OF_ + clazz.getSimpleName());
                                if (filter3.isEmpty()) continue;
                                this.printExplanation(String.format(SHOWING_EFFECT_OF_S_ON_S_, StylesheetTester.print(filter3), Section.class.getSimpleName()));
                                document.add((Element)this.getIndex(EXAMPLE_STYLING_OF_ + clazz.getSimpleName(), 1, stylers));
                                this.printExplanation(END_EFFECT_OF_S_ON_S_);
                                continue;
                            }
                            created = this.createElement(EXAMPLE_STYLING_OF_ + clazz.getSimpleName(), clazz, stylers);
                            filter = StylesheetTester.filter(stylers, created, EXAMPLE_STYLING_OF_ + clazz.getSimpleName());
                            if (filter.isEmpty()) continue;
                            this.printExplanation(String.format(SHOWING_EFFECT_OF_S_ON_S_, StylesheetTester.print(filter), created.getClass().getSimpleName()));
                            document.add(created);
                            this.printExplanation(END_EFFECT_OF_S_ON_S_);
                            continue;
                        }
                        if (!clazz.equals(TextElementArray.class) || (filter = StylesheetTester.filter(stylers, created = this.createElement(EXAMPLE_STYLING_OF_ + Paragraph.class.getSimpleName(), Paragraph.class, stylers), EXAMPLE_STYLING_OF_ + Paragraph.class.getSimpleName())).isEmpty()) continue;
                        this.printExplanation(String.format(SHOWING_EFFECT_OF_S_ON_S_, StylesheetTester.print(filter), created.getClass().getSimpleName()));
                        document.add(created);
                        this.printExplanation(END_EFFECT_OF_S_ON_S_);
                    }
                    continue;
                }
                if (first instanceof Table) {
                    document.newPage();
                    this.printExplanation(String.format(TRYING_TO_SHOW_THE_EFFECT_OF_S_ON_S_, e.getKey(), Arrays.toString(setting), first.getSupportedClasses()));
                    PdfPTable table = (PdfPTable)this.createElement(null, PdfPTable.class, stylers);
                    List<BaseStyler> filter = StylesheetTester.filter(stylers, table, EXAMPLE_STYLING_OF_ + PdfPTable.class.getSimpleName());
                    Table t = (Table)first;
                    int cells = t.getColumns() * 25;
                    for (int i = 0; i < cells; ++i) {
                        table.addCell("cell" + i);
                    }
                    this.printExplanation(String.format(SHOWING_EFFECT_OF_S_ON_S_, StylesheetTester.print(filter), PdfPTable.class.getSimpleName()));
                    document.add((Element)table);
                    this.printExplanation(END_EFFECT_OF_S_ON_S_);
                    continue;
                }
                if (first instanceof SimpleColumns) {
                    document.newPage();
                    this.printExplanation(String.format(TRYING_TO_SHOW_THE_EFFECT_OF_S_ON_S_, e.getKey(), Arrays.toString(setting), ColumnText.class));
                    SimpleColumns cols = this.createColumns(stylers);
                    int texts = cols.getNumColumns() * 100;
                    for (int i = 0; i < texts; ++i) {
                        cols.addContent((Object)("text" + i), new String[]{(String)e.getKey()});
                    }
                    this.printExplanation(String.format(SHOWING_EFFECT_OF_S_ON_S_, StylesheetTester.print(stylers), ColumnText.class.getSimpleName() + " and " + Phrase.class.getSimpleName()));
                    cols.write();
                    this.printExplanation(END_EFFECT_OF_S_ON_S_);
                    continue;
                }
                if (first instanceof Barcode) {
                    document.newPage();
                    Barcode bc = (Barcode)first;
                    if (bc.getData() == null) {
                        bc.setData((Object)"0123456789012");
                    }
                    this.printExplanation(String.format(TRYING_TO_SHOW_THE_EFFECT_OF_S_ON_S_, e.getKey(), Arrays.toString(setting), com.itextpdf.text.Image.class));
                    com.itextpdf.text.Image barcode = (com.itextpdf.text.Image)this.createElement(null, com.itextpdf.text.Image.class, stylers);
                    List<BaseStyler> filter = StylesheetTester.filter(stylers, barcode, EXAMPLE_STYLING_OF_ + com.itextpdf.text.Image.class.getSimpleName());
                    this.printExplanation(String.format(SHOWING_EFFECT_OF_S_ON_S_, StylesheetTester.print(filter), com.itextpdf.text.Image.class.getSimpleName()));
                    document.add((Element)barcode);
                    this.printExplanation(END_EFFECT_OF_S_ON_S_);
                    continue;
                }
                if (first instanceof SVG) {
                    document.newPage();
                    SVG svgStyler = (SVG)first;
                    if (svgStyler.getData() == null) {
                        svgStyler.setData((Object)"<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"200\" height=\"200\" version=\"1.1\"><defs><filter id=\"test\" filterUnits=\"objectBoundingBox\" x=\"0\" y=\"0\" width=\"1.5\" height=\"4\"><feOffset result=\"Off1\" dx=\"15\" dy=\"20\" /><feFlood style=\"flood-color:#ff0000;flood-opacity:0.8\" /><feComposite in2=\"Off1\" operator=\"in\" result=\"C1\" /><feOffset in=\"SourceGraphic\" result=\"Off2\" dx=\"30\" dy=\"40\" /><feFlood style=\"flood-color:#ff0000;flood-opacity:0.4\" /><feComposite in2=\"Off2\" operator=\"in\" result=\"C2\" /><feMerge><feMergeNode in=\"C2\" /><feMergeNode in=\"C1\" /><feMergeNode in=\"SourceGraphic\" /></feMerge></filter></defs><text x=\"30\" y=\"100\" style=\"font:36px verdana bold;fill:blue;filter:url(#test)\">Test text for SVG!</text></svg>");
                    }
                    this.printExplanation(String.format(TRYING_TO_SHOW_THE_EFFECT_OF_S_ON_S_, e.getKey(), Arrays.toString(setting), com.itextpdf.text.Image.class));
                    com.itextpdf.text.Image svg = (com.itextpdf.text.Image)this.createElement(null, com.itextpdf.text.Image.class, stylers);
                    List<BaseStyler> filter = StylesheetTester.filter(stylers, svg, EXAMPLE_STYLING_OF_ + com.itextpdf.text.Image.class.getSimpleName());
                    this.printExplanation(String.format(SHOWING_EFFECT_OF_S_ON_S_, StylesheetTester.print(filter), com.itextpdf.text.Image.class.getSimpleName()));
                    document.add((Element)svg);
                    this.printExplanation(END_EFFECT_OF_S_ON_S_);
                    continue;
                }
                if (!(first instanceof Chart)) continue;
                document.newPage();
                Chart chartStyler = (Chart)first;
                switch (chartStyler.getType()) {
                    case AREA: 
                    case BAR: 
                    case BAR3D: 
                    case LINE: 
                    case LINE3D: {
                        chartStyler.setData((Object)new DefaultCategoryDataset());
                        break;
                    }
                    case PIE: 
                    case PIE3D: {
                        chartStyler.setData((Object)new DefaultPieDataset());
                        break;
                    }
                    case XYAREA: 
                    case XYLINE: {
                        chartStyler.setData((Object)new DefaultXYDataset());
                        break;
                    }
                    case TIME: {
                        chartStyler.setData((Object)new TimeSeriesCollection());
                    }
                }
                this.printExplanation(String.format(TRYING_TO_SHOW_THE_EFFECT_OF_S_ON_S_, e.getKey(), Arrays.toString(setting), com.itextpdf.text.Image.class));
                com.itextpdf.text.Image chart = (com.itextpdf.text.Image)this.createElement(null, com.itextpdf.text.Image.class, stylers);
                List<BaseStyler> filter = StylesheetTester.filter(stylers, chart, EXAMPLE_STYLING_OF_ + com.itextpdf.text.Image.class.getSimpleName());
                this.printExplanation(String.format(SHOWING_EFFECT_OF_S_ON_S_, StylesheetTester.print(filter), com.itextpdf.text.Image.class.getSimpleName()));
                document.add((Element)chart);
                this.printExplanation(END_EFFECT_OF_S_ON_S_);
            }
            catch (IOException ex) {
                throw new VectorPrintException((Throwable)ex);
            }
            catch (InstantiationException ex) {
                throw new VectorPrintException((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new VectorPrintException((Throwable)ex);
            }
        }
    }

    private void printExplanation(String txt) throws DocumentException {
        Font f = FontFactory.getFont((String)"Courier", (float)10.0f, (BaseColor)BaseColor.MAGENTA);
        Paragraph paragraph = new Paragraph(txt, f);
        float padding = ItextHelper.mmToPts((float)2.0f);
        for (Chunk c : paragraph.getChunks()) {
            c.setBackground(new BaseColor(230, 230, 230), padding, padding, padding, padding);
        }
        this.getDocument().add((Element)paragraph);
        this.newLine();
    }

    private static List<BaseStyler> filter(List<BaseStyler> stylers, Object element, Object data) {
        ArrayList<BaseStyler> l = new ArrayList<BaseStyler>(stylers.size());
        stylers.stream().filter(bs -> bs.canStyle(element) && bs.shouldStyle(data, element)).forEach(bs -> l.add((BaseStyler)bs));
        return l;
    }

    private static String print(List<BaseStyler> stylers) {
        StringBuilder sb = new StringBuilder(stylers.size() * 20);
        for (BaseStyler styler : stylers) {
            sb.append(styler.getClass().getSimpleName()).append(", ");
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 2).toString() : "";
    }
}

