/*
 * Decompiled with CFR 0.152.
 */
package com.vectorprint.vectorprintreportgui;

import com.vectorprint.VectorPrintRuntimeException;
import com.vectorprint.configuration.binding.parameters.ParameterHelper;
import com.vectorprint.configuration.parameters.Parameterizable;
import com.vectorprint.vectorprintreportgui.DefaultValue;
import com.vectorprint.vectorprintreportgui.ParameterProps;
import com.vectorprint.vectorprintreportgui.ViewHelper;
import com.vectorprint.vectorprintreportgui.text.SearchableTextArea;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.paint.Color;
import javafx.util.Callback;

public class TableViewController
implements Initializable {
    private final ObservableList<ParameterProps> parameters = FXCollections.observableArrayList(new ArrayList(25));
    @FXML
    private TextField configString;
    @FXML
    private TableView<ParameterProps> parameterTable;
    @FXML
    private TableColumn<ParameterProps, String> pKey;
    @FXML
    private TableColumn<ParameterProps, ParameterProps> pValue;
    @FXML
    private TableColumn<ParameterProps, String> pType;
    @FXML
    private TableColumn<ParameterProps, String> pDefault;
    @FXML
    private TableColumn<ParameterProps, String> pReset;
    @FXML
    private TableColumn<ParameterProps, String> pDeclaringClass;
    private SearchableTextArea help;
    private SearchableTextArea error;
    private Tab helpTab;
    private CheckBox pdf1a;
    private CheckBox toc;
    private Set<DefaultValue> defaults;
    private final ObjectProperty<Parameterizable> currentParameterizable = new SimpleObjectProperty();

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.parameterTable.setItems(this.parameters);
            this.pDeclaringClass.setCellValueFactory((Callback)new PropertyValueFactory("declaringClass"));
            this.pDeclaringClass.setCellFactory(p -> new TableCell<ParameterProps, String>(){

                protected void updateItem(String t, boolean bln) {
                    super.updateItem((Object)t, bln);
                    this.setText(t);
                    if (t != null && this.getTableRow().getItem() != null) {
                        this.setTooltip(ViewHelper.tip(((ParameterProps)this.getTableRow().getItem()).getHelp()));
                    }
                }
            });
            this.pType.setCellValueFactory((Callback)new PropertyValueFactory("type"));
            this.pType.setCellFactory(p -> new TableCell<ParameterProps, String>(){

                protected void updateItem(String t, boolean bln) {
                    super.updateItem((Object)t, bln);
                    this.setText(t);
                    if (t == null) {
                        return;
                    }
                    this.setTooltip(ViewHelper.tip(t));
                }
            });
            this.pKey.setCellValueFactory((Callback)new PropertyValueFactory("key"));
            this.pKey.setCellFactory(param -> new TableCell<ParameterProps, String>(){

                protected void updateItem(String item, boolean empty) {
                    this.setText(item);
                    if (item == null) {
                        return;
                    }
                    this.setTooltip(ViewHelper.tip(item + " (click for help)"));
                    this.setOnMouseClicked(event -> {
                        Parameterizable p = (Parameterizable)TableViewController.this.currentParameterizable.get();
                        TableViewController.this.help.searchArea(p.getClass().getSimpleName() + ": ", false);
                        TableViewController.this.help.searchArea("key=" + item, false);
                        TableViewController.this.helpTab.getTabPane().getSelectionModel().select((Object)TableViewController.this.helpTab);
                        TableViewController.this.help.requestFocus();
                    });
                }
            });
            this.pValue.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ParameterProps, ParameterProps>, ObservableValue<ParameterProps>>(){

                public ObservableValue<ParameterProps> call(TableColumn.CellDataFeatures<ParameterProps, ParameterProps> param) {
                    return (ObservableValue)param.getValue();
                }
            });
            this.pValue.setCellFactory(param -> new TableCell<ParameterProps, ParameterProps>(){

                protected void updateItem(ParameterProps item, boolean empty) {
                    this.setGraphic(null);
                    if (item == null) {
                        return;
                    }
                    Class valueClass = item.getValueClass();
                    if (Boolean.class.equals((Object)valueClass) || Boolean.TYPE.equals(valueClass)) {
                        CheckBox checkBox = new CheckBox();
                        if (item.getKey().equals("pdfa")) {
                            this.bindToCheckbox(checkBox, item, TableViewController.this.pdf1a);
                        } else if (item.getKey().equals("toc")) {
                            this.bindToCheckbox(checkBox, item, TableViewController.this.toc);
                        }
                        checkBox.setSelected(Boolean.parseBoolean(item.getVal()));
                        this.setGraphic((Node)checkBox);
                    } else if (valueClass.isEnum()) {
                        ComboBox comboBox = new ComboBox();
                        ObservableList ol = FXCollections.observableArrayList();
                        for (Object o : valueClass.getEnumConstants()) {
                            ol.add((Object)String.valueOf(o));
                        }
                        comboBox.setItems(ol);
                        comboBox.getSelectionModel().select((Object)item.getVal());
                        comboBox.valueProperty().addListener((ChangeListener)item);
                        this.setGraphic((Node)comboBox);
                    } else if (java.awt.Color.class.equals((Object)valueClass)) {
                        java.awt.Color col = (java.awt.Color)item.getRawValue();
                        ColorPicker cp = col == null ? new ColorPicker() : new ColorPicker(new Color((double)(col.getRed() / 255), (double)(col.getGreen() / 255), (double)(col.getBlue() / 255), (double)(col.getAlpha() / 255)));
                        cp.valueProperty().addListener((ChangeListener)item);
                        this.setGraphic((Node)cp);
                    } else {
                        TextField textField = new TextField(item.getVal());
                        textField.textProperty().addListener((observable, oldValue, newValue) -> {
                            textField.getStyleClass().remove((Object)"error");
                            try {
                                item.setValue((String)newValue);
                            }
                            catch (Exception e) {
                                textField.getStyleClass().add((Object)"error");
                                ViewHelper.writeStackTrace(e, TableViewController.this.error);
                            }
                        });
                        this.setGraphic((Node)textField);
                    }
                }

                private void bindToCheckbox(CheckBox child, ParameterProps item, CheckBox master) {
                    child.selectedProperty().bindBidirectional((Property)master.selectedProperty());
                    child.selectedProperty().addListener((ChangeListener)item);
                }
            });
            this.pDefault.setCellValueFactory((Callback)new PropertyValueFactory("val"));
            this.pDefault.setCellFactory(p -> new TableCell<ParameterProps, String>(){

                protected void updateItem(String v, boolean bln) {
                    this.setGraphic(null);
                    if (v == null) {
                        return;
                    }
                    ParameterProps pp = (ParameterProps)this.getTableView().getItems().get(this.getTableRow().getIndex());
                    CheckBox checkbox = new CheckBox();
                    DefaultValue defaultValue = new DefaultValue(((Parameterizable)TableViewController.this.currentParameterizable.get()).getClass().getSimpleName(), pp.getKey(), pp.getVal(), ParameterHelper.SUFFIX.set_default);
                    checkbox.setSelected(TableViewController.this.defaults.contains(defaultValue));
                    checkbox.setTooltip(ViewHelper.tip(String.format("use value as default for %s in %s", pp.getKey(), ((Parameterizable)TableViewController.this.currentParameterizable.get()).getClass().getSimpleName())));
                    this.setGraphic((Node)checkbox);
                    checkbox.setOnAction(e -> {
                        TableViewController.this.defaults.remove(defaultValue);
                        if (checkbox.isSelected()) {
                            TableViewController.this.defaults.add(defaultValue);
                            TableViewController.this.configString.clear();
                            TableViewController.this.configString.appendText(((Parameterizable)TableViewController.this.currentParameterizable.get()).getClass().getSimpleName());
                            TableViewController.this.configString.appendText(".");
                            TableViewController.this.configString.appendText(pp.getKey());
                            TableViewController.this.configString.appendText(".");
                            TableViewController.this.configString.appendText(ParameterHelper.SUFFIX.set_default.name());
                            TableViewController.this.configString.appendText("=");
                            TableViewController.this.configString.appendText(pp.getVal());
                        } else {
                            TableViewController.this.configString.clear();
                        }
                    });
                }
            });
            this.pReset.setCellValueFactory((Callback)new PropertyValueFactory("val"));
            this.pReset.setCellFactory(p -> new TableCell<ParameterProps, String>(){

                protected void updateItem(String v, boolean bln) {
                    this.setGraphic(null);
                    if (v == null) {
                        return;
                    }
                    ParameterProps pp = (ParameterProps)this.getTableView().getItems().get(this.getTableRow().getIndex());
                    Button button = new Button("reset");
                    button.setTooltip(ViewHelper.tip(String.format("click to reset to default value: %s", pp.getDefault())));
                    this.setGraphic((Node)button);
                    button.setOnAction(e -> pp.resetToDefault());
                }
            });
        }
        catch (NoClassDefFoundError ex) {
            Logger.getLogger(TableViewController.class.getName()).log(Level.SEVERE, null, ex);
            throw new VectorPrintRuntimeException((Throwable)ex);
        }
        catch (Exception ex) {
            Logger.getLogger(TableViewController.class.getName()).log(Level.SEVERE, null, ex);
            throw new VectorPrintRuntimeException((Throwable)ex);
        }
    }

    public ObservableList<ParameterProps> getParameters() {
        return this.parameters;
    }

    public TextField getConfigString() {
        return this.configString;
    }

    public ObjectProperty<Parameterizable> getCurrentParameterizable() {
        return this.currentParameterizable;
    }

    public void setHelp(SearchableTextArea help) {
        this.help = help;
    }

    public void setError(SearchableTextArea error) {
        this.error = error;
    }

    public void setHelpTab(Tab helpTab) {
        this.helpTab = helpTab;
    }

    public void setPdf1a(CheckBox pdf1a) {
        this.pdf1a = pdf1a;
    }

    public void setToc(CheckBox toc) {
        this.toc = toc;
    }

    public void setDefaults(Set<DefaultValue> defaults) {
        this.defaults = defaults;
    }
}

