/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.ApplicationUnavailableException;
import com.versionone.om.AssetID;
import com.versionone.om.Attachment;
import com.versionone.om.AttachmentLengthExceededException;
import com.versionone.om.Conversation;
import com.versionone.om.Entity;
import com.versionone.om.Expression;
import com.versionone.om.ICustomAttributeDictionary;
import com.versionone.om.ICustomDropdownDictionary;
import com.versionone.om.Link;
import com.versionone.om.Member;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.Note;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.AttachmentFilter;
import com.versionone.om.filters.LinkFilter;
import com.versionone.om.filters.NoteFilter;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="BaseAsset", defaultAttributeSelectionNames="Name")
public abstract class BaseAsset
extends Entity {
    protected static final int STATE_CLOSED = 128;
    protected static final int STATE_ACTIVE = 64;
    private ICustomAttributeDictionary customField;
    private ICustomDropdownDictionary customDropdown;

    BaseAsset(V1Instance instance) {
        super(instance);
    }

    BaseAsset(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    public String getURL() {
        return this.getEntityURL();
    }

    public String getName() {
        return (String)this.get("Name");
    }

    public void setName(String name) {
        this.set("Name", name);
    }

    public String getDescription() {
        return (String)this.get("Description");
    }

    public void setDescription(String value) {
        this.set("Description", value);
    }

    public Collection<Expression> getMentionedInExpressions() {
        return this.getMultiRelation("MentionedInExpressions");
    }

    public Collection<Attachment> getAttachments(AttachmentFilter filter) {
        filter = filter != null ? filter : new AttachmentFilter();
        filter.asset.clear();
        filter.asset.add(this);
        return this.getInstance().get().attachments(filter);
    }

    public Collection<Note> getNotes(NoteFilter filter) {
        filter = filter != null ? filter : new NoteFilter();
        filter.asset.clear();
        filter.asset.add(this);
        return this.getInstance().get().notes(filter);
    }

    public Collection<Link> getLinks(LinkFilter filter) {
        filter = filter == null ? new LinkFilter() : filter;
        filter.asset.clear();
        filter.asset.add(this);
        return this.getInstance().get().links(filter);
    }

    public boolean isActive() {
        return this.isActiveImpl();
    }

    public boolean isClosed() {
        return this.isClosedImpl();
    }

    boolean isActiveImpl() {
        return this.get("AssetState", true).equals(64);
    }

    boolean isClosedImpl() {
        return this.get("AssetState", true).equals(128);
    }

    public boolean canDelete() {
        return this.canDeleteImpl();
    }

    boolean canDeleteImpl() {
        return this.getInstance().canExecuteOperation(this, "Delete");
    }

    public void delete() throws UnsupportedOperationException {
        this.save();
        this.getInstance().executeOperation(this, "Delete");
    }

    public ICustomAttributeDictionary getCustomField() {
        if (this.customField == null) {
            this.customField = new Entity.SimpleCustomAttributeDictionary(this);
        }
        return this.customField;
    }

    public ICustomDropdownDictionary getCustomDropdown() {
        if (this.customDropdown == null) {
            this.customDropdown = new Entity.ListCustomAttributeDictionary(this);
        }
        return this.customDropdown;
    }

    public Link createLink(String name, String url, boolean onMenu) {
        return this.getInstance().create().link(name, this, url, onMenu);
    }

    public Link createLink(String name, String url, boolean onMenu, Map<String, Object> attributes) {
        return this.getInstance().create().link(name, this, url, onMenu, attributes);
    }

    public Note createNote(String name, String content, boolean personal) {
        return this.getInstance().create().note(name, this, content, personal);
    }

    public Note createNote(String name, String content, boolean personal, Map<String, Object> attributes) {
        return this.getInstance().create().note(name, this, content, personal, attributes);
    }

    public Attachment createAttachment(String name, String fileName, InputStream stream) throws AttachmentLengthExceededException, ApplicationUnavailableException {
        return this.getInstance().create().attachment(name, this, fileName, stream);
    }

    public Attachment createAttachment(String name, String fileName, InputStream stream, Map<String, Object> attributes) throws AttachmentLengthExceededException, ApplicationUnavailableException {
        return this.getInstance().create().attachment(name, this, fileName, stream, attributes);
    }

    public Conversation createConversation(Member author, String content) {
        Conversation conversation = this.getInstance().create().conversation(author, content);
        Iterator<Expression> iterator = conversation.getContainedExpressions().iterator();
        iterator.next().getMentions().add(this);
        conversation.save();
        return conversation;
    }

    public Conversation createConversation(Member author, String content, Map<String, Object> attributes) {
        Conversation conversation = this.getInstance().create().conversation(author, content, attributes);
        Iterator<Expression> iterator = conversation.getContainedExpressions().iterator();
        if (iterator.hasNext()) {
            iterator.next().getMentions().add(this);
        }
        conversation.save();
        return conversation;
    }

    public boolean canClose() {
        return this.canCloseImpl();
    }

    boolean canCloseImpl() {
        return this.getInstance().canExecuteOperation(this, "Inactivate");
    }

    public void close() throws UnsupportedOperationException {
        this.save();
        this.closeImpl();
        this.clearCache("AssetState");
    }

    abstract void closeImpl() throws UnsupportedOperationException;

    public boolean canReactivate() {
        return this.canReactivateImpl();
    }

    boolean canReactivateImpl() {
        return this.getInstance().canExecuteOperation(this, "Reactivate");
    }

    public void reactivate() throws UnsupportedOperationException {
        this.reactivateImpl();
        this.save();
        this.clearCache("AssetState");
    }

    abstract void reactivateImpl() throws UnsupportedOperationException;
}

