/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.AssetID;
import com.versionone.om.BuildRun;
import com.versionone.om.Defect;
import com.versionone.om.Goal;
import com.versionone.om.IListValueProperty;
import com.versionone.om.Issue;
import com.versionone.om.Iteration;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.MetaRenamedAttribute;
import com.versionone.om.Rank;
import com.versionone.om.Request;
import com.versionone.om.SecondaryWorkitem;
import com.versionone.om.Task;
import com.versionone.om.Team;
import com.versionone.om.Test;
import com.versionone.om.Theme;
import com.versionone.om.V1Instance;
import com.versionone.om.Workitem;
import com.versionone.om.filters.SecondaryWorkitemFilter;
import com.versionone.om.filters.WorkitemFilter;
import com.versionone.om.listvalue.WorkitemPriority;
import com.versionone.om.listvalue.WorkitemSource;
import com.versionone.om.listvalue.WorkitemStatus;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="PrimaryWorkitem", defaultOrderByToken="PrimaryWorkitem.Order")
public abstract class PrimaryWorkitem
extends Workitem {
    PrimaryWorkitem(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    PrimaryWorkitem(V1Instance instance) {
        super(instance);
    }

    public Team getTeam() {
        return this.getRelation(Team.class, "Team");
    }

    public void setTeam(Team team) {
        this.setRelation("Team", team);
    }

    @MetaRenamedAttribute(value="Timebox")
    public Iteration getIteration() {
        return this.getRelation(Iteration.class, "Timebox");
    }

    public void setIteration(Iteration iteration) {
        this.setRelation("Timebox", iteration);
    }

    @MetaRenamedAttribute(value="Parent")
    public Theme getTheme() {
        return this.getRelation(Theme.class, "Parent");
    }

    public void setTheme(Theme theme) {
        this.setRelation("Parent", theme);
    }

    public IListValueProperty getStatus() {
        return this.getListValue(WorkitemStatus.class, "Status");
    }

    public IListValueProperty getPriority() {
        return this.getListValue(WorkitemPriority.class, "Priority");
    }

    public IListValueProperty getSource() {
        return this.getListValue(WorkitemSource.class, "Source");
    }

    @MetaRenamedAttribute(value="Order")
    public Rank<PrimaryWorkitem> getRankOrder() {
        return this.getRank("Order");
    }

    public Double getEstimate() {
        return (Double)this.get("Estimate");
    }

    public void setEstimate(Double estimate) {
        this.set("Estimate", estimate);
    }

    public Collection<Goal> getGoals() {
        return this.getMultiRelation("Goals");
    }

    public Collection<Request> getRequests() {
        return this.getMultiRelation("Requests");
    }

    public Collection<Issue> getIssues() {
        return this.getMultiRelation("Issues");
    }

    public Collection<Issue> getBlockingIssues() {
        return this.getMultiRelation("BlockingIssues");
    }

    public Collection<Defect> getAffectedByDefects() {
        return this.getMultiRelation("AffectedByDefects");
    }

    @MetaRenamedAttribute(value="CompletedInBuildRuns")
    public Collection<BuildRun> getCompletedIn() {
        return this.getMultiRelation("CompletedInBuildRuns");
    }

    public Task createTask(String name) {
        return this.getInstance().create().task(name, this);
    }

    public Task createTask(String name, Map<String, Object> attributes) {
        return this.getInstance().create().task(name, this, attributes);
    }

    public Test createTest(String name) {
        return this.getInstance().create().test(name, this);
    }

    public Test createTest(String name, Map<String, Object> attributes) {
        return this.getInstance().create().test(name, this, attributes);
    }

    public Double getTotalDetailEstimate(WorkitemFilter filter) {
        return this.getSum("ChildrenMeAndDown", filter != null ? filter : new WorkitemFilter(), "DetailEstimate");
    }

    public Double getTotalDone(WorkitemFilter filter) {
        return this.getSum("ChildrenMeAndDown", filter != null ? filter : new WorkitemFilter(), "Actuals.Value");
    }

    public Double getTotalToDo(WorkitemFilter filter) {
        return this.getSum("ChildrenMeAndDown", filter != null ? filter : new WorkitemFilter(), "ToDo");
    }

    public Collection<SecondaryWorkitem> getSecondaryWorkitems(SecondaryWorkitemFilter filter) {
        if (filter == null) {
            filter = new SecondaryWorkitemFilter();
        }
        filter.parent.clear();
        filter.parent.add(this);
        return this.getInstance().get().secondaryWorkitems(filter);
    }
}

