/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.AssetID;
import com.versionone.om.Defect;
import com.versionone.om.Epic;
import com.versionone.om.IListValueProperty;
import com.versionone.om.Issue;
import com.versionone.om.Member;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.MetaRenamedAttribute;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.ProjectAsset;
import com.versionone.om.Rank;
import com.versionone.om.Story;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.EpicFilter;
import com.versionone.om.filters.PrimaryWorkitemFilter;
import com.versionone.om.listvalue.RequestPriority;
import com.versionone.om.listvalue.RequestResolution;
import com.versionone.om.listvalue.RequestStatus;
import com.versionone.om.listvalue.RequestType;
import com.versionone.om.listvalue.WorkitemSource;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Request")
public class Request
extends ProjectAsset {
    Request(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Request(V1Instance instance) {
        super(instance);
    }

    public Member getOwner() {
        return this.getRelation(Member.class, "Owner");
    }

    public void setOwner(Member value) {
        this.setRelation("Owner", value);
    }

    @MetaRenamedAttribute(value="Order")
    public Rank<Request> getRankOrder() {
        return this.getRank("Order");
    }

    public IListValueProperty getSource() {
        return this.getListValue(WorkitemSource.class, "Source");
    }

    public IListValueProperty getType() {
        return this.getListValue(RequestType.class, "Category");
    }

    public IListValueProperty getStatus() {
        return this.getListValue(RequestStatus.class, "Status");
    }

    public IListValueProperty getPriority() {
        return this.getListValue(RequestPriority.class, "Priority");
    }

    public String getRequestedBy() {
        return (String)this.get("RequestedBy");
    }

    public void setRequestedBy(String value) {
        this.set("RequestedBy", value);
    }

    public String getReference() {
        return (String)this.get("Reference");
    }

    public void setReference(String value) {
        this.set("Reference", value);
    }

    public IListValueProperty getResolutionReason() {
        return this.getListValue(RequestResolution.class, "ResolutionReason");
    }

    public String getResolutionDetails() {
        return (String)this.get("Resolution");
    }

    public void setResolutionDetails(String value) {
        this.set("Resolution", value);
    }

    public Collection<PrimaryWorkitem> getPrimaryWorkitems(PrimaryWorkitemFilter filter) {
        filter = filter != null ? filter : new PrimaryWorkitemFilter();
        filter.requests.clear();
        filter.requests.add(this);
        return this.getInstance().get().primaryWorkitems(filter);
    }

    public Collection<Issue> getIssues() {
        return this.getMultiRelation("Issues");
    }

    public Collection<Epic> getEpics(EpicFilter filter) {
        filter = filter != null ? filter : new EpicFilter();
        filter.requests.clear();
        filter.requests.add(this);
        return this.getInstance().get().epics(filter);
    }

    @Override
    void closeImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Inactivate");
    }

    @Override
    void reactivateImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Reactivate");
    }

    public Story generateStory() {
        return this.generateStory(null);
    }

    public Story generateStory(Map<String, Object> attributes) {
        Story result = this.getInstance().createNew(Story.class, this);
        this.getInstance().create().addAttributes(result, attributes);
        result.save();
        return result;
    }

    public Defect generateDefect() {
        return this.generateDefect(null);
    }

    public Defect generateDefect(Map<String, Object> attributes) {
        Defect result = this.getInstance().createNew(Defect.class, this);
        this.getInstance().create().addAttributes(result, attributes);
        result.save();
        return result;
    }
}

