/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.Oid;
import com.versionone.apiclient.ConnectionException;
import com.versionone.apiclient.IAPIConnector;
import com.versionone.apiclient.IMetaModel;
import com.versionone.apiclient.MetaModel;
import com.versionone.apiclient.Services;
import com.versionone.apiclient.V1APIConnector;
import com.versionone.apiclient.Version;
import com.versionone.om.ApiClientInternals;
import com.versionone.om.ProxySettings;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class V1ConnectionValidator {
    private static final String MEMBER_CONNECT_PARAM = "loc.v1/?Member";
    private final String connectionURL;
    private final String username;
    private final String password;
    private final ProxySettings proxySettings;
    private final Map<String, String> customHttpHeaders = new HashMap<String, String>();

    public V1ConnectionValidator(String connectionURL, String username, String password) {
        this(connectionURL, username, password, null);
    }

    public V1ConnectionValidator(String connectionURL, String username, String password, ProxySettings proxySettings) {
        this.connectionURL = connectionURL == null ? "" : (!connectionURL.endsWith("/") ? connectionURL + "/" : connectionURL);
        this.username = username;
        this.password = password;
        this.proxySettings = proxySettings;
    }

    public Map<String, String> getCustomHttpHeaders() {
        return this.customHttpHeaders;
    }

    public void test() throws ConnectionException {
        this.test(null);
    }

    public void test(String version) throws ConnectionException {
        try {
            this.checkConnection();
            this.checkVersion(version);
            this.checkAuthentication();
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ConnectionException("Connection Check: " + ex.getMessage(), ex);
        }
    }

    public void checkConnection() throws ConnectionException {
        V1APIConnector connector = this.populateHeaders(new V1APIConnector(this.getApplicationURL() + MEMBER_CONNECT_PARAM, this.username, this.password, ApiClientInternals.getProxyProvider(this.proxySettings)));
        try {
            connector.getData().close();
        }
        catch (Exception ex) {
            throw new ConnectionException("Application not found at the URL: " + this.getApplicationURL(), ex);
        }
    }

    public void checkVersion(String version) throws ConnectionException {
        MetaModel meta = this.createMetaModel();
        meta.getAssetType("Member");
        if (version != null && version.length() > 0 && (meta.getVersion() == null || meta.getVersion().compareTo(new Version(version)) < 0)) {
            throw new ConnectionException(MessageFormat.format("VersionOne Release {0} or above is required (found {1}).", version, meta.getVersion()));
        }
    }

    private MetaModel createMetaModel() {
        return new MetaModel((IAPIConnector)this.populateHeaders(new V1APIConnector(this.getApplicationURL() + "meta.v1/", this.username, this.password, ApiClientInternals.getProxyProvider(this.proxySettings))), false);
    }

    public void checkAuthentication() throws ConnectionException {
        Oid loggedin;
        Services services = new Services((IMetaModel)this.createMetaModel(), (IAPIConnector)this.populateHeaders(new V1APIConnector(this.getApplicationURL() + "rest-1.v1/", this.username, this.password, ApiClientInternals.getProxyProvider(this.proxySettings))));
        try {
            loggedin = services.getLoggedIn();
        }
        catch (Exception ex) {
            throw new ConnectionException("Unable to log in. Incorrect username or password.", ex);
        }
        if (loggedin.isNull()) {
            throw new ConnectionException("Unable to retrieve logged in member.");
        }
    }

    private String getApplicationURL() {
        return this.connectionURL;
    }

    private V1APIConnector populateHeaders(V1APIConnector connector) {
        for (String key : this.customHttpHeaders.keySet()) {
            connector.customHttpHeaders.put(key, this.customHttpHeaders.get(key));
        }
        return connector;
    }
}

