/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java;

import com.viridiansoftware.java.ClassAccessFlag;
import com.viridiansoftware.java.FieldInfo;
import com.viridiansoftware.java.MethodInfo;
import com.viridiansoftware.java.ResolvedTypeVariable;
import com.viridiansoftware.java.TypeVariableResolver;
import com.viridiansoftware.java.UnresolvedTypeVariableException;
import com.viridiansoftware.java.attributes.AttributeInfo;
import com.viridiansoftware.java.attributes.Attributes;
import com.viridiansoftware.java.attributes.BootstrapMethods;
import com.viridiansoftware.java.attributes.EnclosingMethod;
import com.viridiansoftware.java.attributes.InnerClasses;
import com.viridiansoftware.java.attributes.NestHost;
import com.viridiansoftware.java.attributes.NestMembers;
import com.viridiansoftware.java.attributes.RuntimeVisibleAnnotations;
import com.viridiansoftware.java.constants.ConstantClass;
import com.viridiansoftware.java.constants.ConstantNameAndType;
import com.viridiansoftware.java.constants.ConstantPool;
import com.viridiansoftware.java.signature.ClassSignature;
import com.viridiansoftware.java.signature.antlr.SignatureParser;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ClassFile
implements TypeVariableResolver {
    private final DataInputStream input;
    private final int minorVersion;
    private final int majorVersion;
    private final ConstantPool constantPool;
    private final int accessFlags;
    private final List<ClassAccessFlag> classAccessFlags = new ArrayList<ClassAccessFlag>(2);
    private final ConstantClass thisClass;
    private final ConstantClass superClass;
    private final ConstantClass[] interfaces;
    private final FieldInfo[] fields;
    private final MethodInfo[] methods;
    private final Attributes attributes;
    private String thisSignature;
    private String superSignature;
    private ClassSignature classSignature;
    private NestHost nestHost;
    private NestMembers nestMembers;
    private InnerClasses innerClasses;
    private EnclosingMethod enclosingMethod;
    private BootstrapMethods bootstrapMethods;
    private RuntimeVisibleAnnotations runtimeVisibleAnnotations;

    public ClassFile(InputStream stream) throws IOException {
        AttributeInfo runtimeVisibleAnnotationsInfo;
        AttributeInfo bootstrapMethodsInfo;
        AttributeInfo enclosingMethodInfo;
        AttributeInfo innerClassesInfo;
        AttributeInfo nestMembersInfo;
        AttributeInfo nestHostInfo;
        this.input = new DataInputStream(stream);
        int magic = this.input.readInt();
        if (magic != -889275714) {
            throw new IOException("Invalid class magic: " + Integer.toHexString(magic));
        }
        this.minorVersion = this.input.readUnsignedShort();
        this.majorVersion = this.input.readUnsignedShort();
        this.constantPool = new ConstantPool(this.majorVersion, this.minorVersion, this.input);
        this.accessFlags = this.input.readUnsignedShort();
        for (ClassAccessFlag classAccessFlag : ClassAccessFlag.values()) {
            if ((classAccessFlag.getMask() & this.accessFlags) != classAccessFlag.getMask()) continue;
            this.classAccessFlags.add(classAccessFlag);
        }
        this.thisClass = (ConstantClass)this.constantPool.get(this.input.readUnsignedShort());
        this.superClass = (ConstantClass)this.constantPool.get(this.input.readUnsignedShort());
        this.interfaces = new ConstantClass[this.input.readUnsignedShort()];
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.interfaces[i] = (ConstantClass)this.constantPool.get(this.input.readUnsignedShort());
        }
        this.fields = this.readFields();
        this.methods = this.readMethods();
        this.attributes = new Attributes(this.input, this.constantPool);
        stream.close();
        AttributeInfo info = this.attributes.get("Signature");
        if (info != null) {
            short idx = info.getDataInputStream().readShort();
            String signature = (String)this.constantPool.get(idx);
            int count = 0;
            block6: for (int i = 0; i < signature.length(); ++i) {
                char ch = signature.charAt(i);
                switch (ch) {
                    case '<': {
                        ++count;
                        continue block6;
                    }
                    case '>': {
                        --count;
                        continue block6;
                    }
                    default: {
                        if (count != 0) continue block6;
                        this.thisSignature = signature.substring(0, i);
                        this.superSignature = signature.substring(i);
                        break block6;
                    }
                }
            }
            this.classSignature = new ClassSignature(signature);
        }
        if ((nestHostInfo = this.attributes.get("NestHost")) != null) {
            this.nestHost = new NestHost(nestHostInfo.getDataInputStream(), this.constantPool);
        }
        if ((nestMembersInfo = this.attributes.get("NestMembers")) != null) {
            this.nestMembers = new NestMembers(nestMembersInfo.getDataInputStream(), this.constantPool);
        }
        if ((innerClassesInfo = this.attributes.get("InnerClasses")) != null) {
            this.innerClasses = new InnerClasses(innerClassesInfo.getDataInputStream(), this.constantPool);
        }
        if ((enclosingMethodInfo = this.attributes.get("EnclosingMethod")) != null) {
            this.enclosingMethod = new EnclosingMethod(enclosingMethodInfo.getDataInputStream(), this.constantPool);
        }
        if ((bootstrapMethodsInfo = this.attributes.get("BootstrapMethods")) != null) {
            this.bootstrapMethods = new BootstrapMethods(bootstrapMethodsInfo.getDataInputStream(), this.constantPool);
        }
        if ((runtimeVisibleAnnotationsInfo = this.attributes.get("RuntimeVisibleAnnotations")) != null) {
            this.runtimeVisibleAnnotations = new RuntimeVisibleAnnotations(this.constantPool, runtimeVisibleAnnotationsInfo.getDataInputStream());
        }
    }

    public String getSourceFile() throws IOException {
        return this.attributes.getSourceFile();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public ConstantClass getThisClass() {
        return this.thisClass;
    }

    public ConstantClass getSuperClass() {
        return this.superClass;
    }

    public ConstantClass[] getInterfaces() {
        return this.interfaces;
    }

    public MethodInfo[] getMethods() {
        return this.methods;
    }

    public BootstrapMethods getBootstrapMethods() {
        return this.bootstrapMethods;
    }

    public List<MethodInfo> getClassInitialisationMethods() {
        ArrayList<MethodInfo> results = new ArrayList<MethodInfo>(2);
        for (MethodInfo method : this.methods) {
            if (!method.getName().equals("<clinit>")) continue;
            results.add(method);
        }
        return results;
    }

    public List<MethodInfo> getConstructorMethods() {
        ArrayList<MethodInfo> results = new ArrayList<MethodInfo>(2);
        for (MethodInfo method : this.methods) {
            if (!method.getName().equals("<init>")) continue;
            results.add(method);
        }
        return results;
    }

    public List<MethodInfo> getNonInitMethods() {
        ArrayList<MethodInfo> results = new ArrayList<MethodInfo>(2);
        for (MethodInfo method : this.methods) {
            if (method.getName().equals("<init>") || method.getName().equals("<clinit>")) continue;
            results.add(method);
        }
        return results;
    }

    public List<MethodInfo> getMethod(String name) {
        ArrayList<MethodInfo> results = new ArrayList<MethodInfo>(2);
        for (MethodInfo method : this.methods) {
            if (!name.equals(method.getName())) continue;
            results.add(method);
        }
        return results;
    }

    public MethodInfo getMethod(ConstantNameAndType constantNameAndType) throws IOException {
        for (MethodInfo method : this.methods) {
            if (!method.matches(constantNameAndType)) continue;
            return method;
        }
        return null;
    }

    public int getMethodCount(String name) {
        int count = 0;
        for (MethodInfo method : this.methods) {
            if (!name.equals(method.getName())) continue;
            ++count;
        }
        return count;
    }

    public FieldInfo getField(String name) {
        for (FieldInfo field : this.fields) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public FieldInfo[] getFields() {
        return this.fields;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public List<ClassAccessFlag> getClassAccessFlags() {
        return this.classAccessFlags;
    }

    private FieldInfo[] readFields() throws IOException {
        FieldInfo[] fields = new FieldInfo[this.input.readUnsignedShort()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = new FieldInfo(this.input, this.constantPool);
        }
        return fields;
    }

    private MethodInfo[] readMethods() throws IOException {
        MethodInfo[] methods = new MethodInfo[this.input.readUnsignedShort()];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = new MethodInfo(this.input, this.constantPool, this);
        }
        return methods;
    }

    public String getThisSignature() {
        return this.thisSignature;
    }

    public String getSuperSignature() {
        return this.superSignature;
    }

    public ClassSignature getClassSignature() {
        return this.classSignature;
    }

    @Override
    public ResolvedTypeVariable resolveTypeVariable(String variableName) throws UnresolvedTypeVariableException, IOException {
        if (this.classSignature == null) {
            throw new UnresolvedTypeVariableException(this.getSourceFile(), variableName);
        }
        if (variableName.startsWith("T")) {
            variableName = variableName.substring(1);
        }
        for (int i = 0; i < this.classSignature.getTotalTypeParameters(); ++i) {
            SignatureParser.TypeParameterContext typeParameterContext = this.classSignature.getTypeParameter(i);
            if (!typeParameterContext.identifier().getText().equals(variableName)) continue;
            return new ResolvedTypeVariable(variableName, typeParameterContext);
        }
        throw new UnresolvedTypeVariableException(this.getSourceFile(), variableName);
    }

    public NestHost getNestHost() {
        return this.nestHost;
    }

    public NestMembers getNestMembers() {
        return this.nestMembers;
    }

    public InnerClasses getInnerClasses() {
        return this.innerClasses;
    }

    public EnclosingMethod getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public RuntimeVisibleAnnotations getRuntimeVisibleAnnotations() {
        return this.runtimeVisibleAnnotations;
    }

    public boolean isDefaultScope() {
        if (this.isPrivate()) {
            return false;
        }
        if (this.isPublic()) {
            return false;
        }
        return !this.isProtected();
    }

    public boolean isPublic() {
        return (this.accessFlags & ClassAccessFlag.PUBLIC.getMask()) == ClassAccessFlag.PUBLIC.getMask();
    }

    public boolean isProtected() {
        return (this.accessFlags & ClassAccessFlag.PROTECTED.getMask()) == ClassAccessFlag.PROTECTED.getMask();
    }

    public boolean isPrivate() {
        return (this.accessFlags & ClassAccessFlag.PRIVATE.getMask()) == ClassAccessFlag.PRIVATE.getMask();
    }

    public boolean isInterface() {
        return (this.accessFlags & ClassAccessFlag.INTERFACE.getMask()) == ClassAccessFlag.INTERFACE.getMask();
    }

    public boolean isAbstract() {
        return (this.accessFlags & ClassAccessFlag.ABSTRACT.getMask()) == ClassAccessFlag.ABSTRACT.getMask();
    }

    public boolean isEnum() {
        return (this.accessFlags & ClassAccessFlag.ENUM.getMask()) == ClassAccessFlag.ENUM.getMask();
    }

    public boolean isAnnotation() {
        return (this.accessFlags & ClassAccessFlag.ANNOTATION.getMask()) == ClassAccessFlag.ANNOTATION.getMask();
    }

    public boolean isStatic() {
        return (this.accessFlags & ClassAccessFlag.STATIC.getMask()) == ClassAccessFlag.STATIC.getMask();
    }

    public boolean isFinal() {
        return (this.accessFlags & ClassAccessFlag.FINAL.getMask()) == ClassAccessFlag.FINAL.getMask();
    }

    public Type getType() {
        if ((this.accessFlags & 0x200) == 512) {
            return Type.Interface;
        }
        if (this.superClass != null && this.superClass.getName() != null && this.superClass.getName().equals("java/lang/Enum")) {
            return Type.Enum;
        }
        return Type.Class;
    }

    public static enum Type {
        Class,
        Interface,
        Enum;

    }
}

