/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java;

import com.viridiansoftware.java.FieldAccessFlag;
import com.viridiansoftware.java.attributes.AttributeInfo;
import com.viridiansoftware.java.attributes.Attributes;
import com.viridiansoftware.java.attributes.RuntimeVisibleAnnotations;
import com.viridiansoftware.java.constants.ConstantPool;
import com.viridiansoftware.java.descriptor.FieldDescriptor;
import com.viridiansoftware.java.signature.FieldSignature;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FieldInfo {
    private final int accessFlags;
    private final List<FieldAccessFlag> fieldAccessFlags = new ArrayList<FieldAccessFlag>(2);
    private final String name;
    private final String description;
    private final ConstantPool constantPool;
    private final Attributes attributes;
    private String signature;
    private FieldSignature fieldSignature;
    private FieldDescriptor fieldDescriptor;
    private Object constantValue;
    private RuntimeVisibleAnnotations runtimeVisibleAnnotations;

    FieldInfo(DataInputStream input, ConstantPool constantPool) throws IOException {
        this.accessFlags = input.readUnsignedShort();
        this.constantPool = constantPool;
        for (FieldAccessFlag fieldAccessFlag : FieldAccessFlag.values()) {
            if ((fieldAccessFlag.getMask() & this.accessFlags) != fieldAccessFlag.getMask()) continue;
            this.fieldAccessFlags.add(fieldAccessFlag);
        }
        this.name = (String)constantPool.get(input.readUnsignedShort());
        this.description = (String)constantPool.get(input.readUnsignedShort());
        this.attributes = new Attributes(input, constantPool);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public List<FieldAccessFlag> getFieldAccessFlags() {
        return this.fieldAccessFlags;
    }

    public boolean isDefaultScope() {
        if (this.isPrivate()) {
            return false;
        }
        if (this.isPublic()) {
            return false;
        }
        return !this.isProtected();
    }

    public boolean isPublic() {
        return (this.accessFlags & FieldAccessFlag.PUBLIC.getMask()) > 0;
    }

    public boolean isProtected() {
        return (this.accessFlags & FieldAccessFlag.PROTECTED.getMask()) > 0;
    }

    public boolean isPrivate() {
        return (this.accessFlags & FieldAccessFlag.PRIVATE.getMask()) > 0;
    }

    public boolean isStatic() {
        return (this.accessFlags & FieldAccessFlag.STATIC.getMask()) > 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & FieldAccessFlag.FINAL.getMask()) > 0;
    }

    public boolean isVolatile() {
        return (this.accessFlags & FieldAccessFlag.VOLATILE.getMask()) > 0;
    }

    public boolean isEnum() {
        return (this.accessFlags & FieldAccessFlag.ENUM.getMask()) > 0;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.description;
    }

    public String getSignature() throws IOException {
        if (this.signature != null) {
            return this.signature;
        }
        AttributeInfo info = this.getAttributes().get("Signature");
        if (info != null) {
            short idx = info.getDataInputStream().readShort();
            this.signature = (String)this.constantPool.get(idx);
        }
        return this.signature;
    }

    public FieldDescriptor getFieldDescriptor() {
        if (this.fieldDescriptor == null) {
            this.fieldDescriptor = new FieldDescriptor(this.getType());
        }
        return this.fieldDescriptor;
    }

    public Object getConstantValue() throws IOException {
        if (this.constantValue != null) {
            return this.constantValue;
        }
        AttributeInfo info = this.getAttributes().get("ConstantValue");
        if (info != null) {
            short idx = info.getDataInputStream().readShort();
            this.constantValue = this.constantPool.get(idx);
        }
        return this.constantValue;
    }

    public RuntimeVisibleAnnotations getRuntimeVisibleAnnotations() throws IOException {
        AttributeInfo info;
        if (this.runtimeVisibleAnnotations == null && (info = this.getAttributes().get("RuntimeVisibleAnnotations")) != null) {
            this.runtimeVisibleAnnotations = new RuntimeVisibleAnnotations(this.constantPool, info.getDataInputStream());
        }
        return this.runtimeVisibleAnnotations;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public FieldSignature getFieldSignature() throws IOException {
        if (this.fieldSignature == null && this.getSignature() != null) {
            this.fieldSignature = new FieldSignature(this.getSignature());
        }
        return this.fieldSignature;
    }
}

