/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import com.viridiansoftware.java.constants.ConstantPool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import lombok.NonNull;

public class AttributeInfo {
    private final String name;
    private final byte[] info;

    public AttributeInfo(@NonNull DataInputStream input, @NonNull ConstantPool constantPool) throws IOException {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (constantPool == null) {
            throw new NullPointerException("constantPool is marked @NonNull but is null");
        }
        this.name = (String)constantPool.get(input.readUnsignedShort());
        this.info = new byte[input.readInt()];
        input.readFully(this.info);
    }

    public String getName() {
        return this.name;
    }

    public byte[] getData() {
        return this.info;
    }

    public DataInputStream getDataInputStream() {
        return new DataInputStream(new ByteArrayInputStream(this.info));
    }
}

