/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import com.viridiansoftware.java.attributes.AttributeInfo;
import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import lombok.NonNull;

public class Attributes {
    private final AttributeInfo[] attributes;
    private final ConstantPool constantPool;

    public Attributes(@NonNull DataInputStream input, @NonNull ConstantPool constantPool) throws IOException {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (constantPool == null) {
            throw new NullPointerException("constantPool is marked @NonNull but is null");
        }
        this.constantPool = constantPool;
        this.attributes = this.readAttributs(input);
    }

    private AttributeInfo[] readAttributs(@NonNull DataInputStream input) throws IOException {
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        AttributeInfo[] attrs = new AttributeInfo[input.readUnsignedShort()];
        for (int i = 0; i < attrs.length; ++i) {
            attrs[i] = new AttributeInfo(input, this.constantPool);
        }
        return attrs;
    }

    public AttributeInfo get(String name) {
        if (name == null) {
            return null;
        }
        for (AttributeInfo attr : this.attributes) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public void printAttributeNames() {
        for (AttributeInfo attr : this.attributes) {
            System.out.println(attr.getName());
        }
    }

    public String getSourceFile() throws IOException {
        AttributeInfo data = this.get("SourceFile");
        if (data == null) {
            return null;
        }
        return (String)this.constantPool.get(data.getDataInputStream().readUnsignedShort());
    }
}

