/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import com.viridiansoftware.java.CodeInputStream;
import com.viridiansoftware.java.attributes.AttributeInfo;
import com.viridiansoftware.java.attributes.Attributes;
import com.viridiansoftware.java.attributes.BootstrapMethods;
import com.viridiansoftware.java.attributes.LineNumberTable;
import com.viridiansoftware.java.attributes.LocalVariableTable;
import com.viridiansoftware.java.attributes.TryCatchFinally;
import com.viridiansoftware.java.constants.ConstantClass;
import com.viridiansoftware.java.constants.ConstantMethodRef;
import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import lombok.NonNull;

public class Code {
    private final ConstantPool constantPool;
    private final BootstrapMethods bootstrapMethods;
    private final int maxStack;
    private final int maxLocals;
    private final byte[] codeData;
    private final TryCatchFinally[] exceptionTable;
    private final Attributes attributes;
    private LineNumberTable lineNumberTable;
    private LocalVariableTable localVariableTable;

    public Code(DataInputStream input, @NonNull ConstantPool constantPool, BootstrapMethods bootstrapMethods) throws IOException {
        if (constantPool == null) {
            throw new NullPointerException("constantPool is marked @NonNull but is null");
        }
        this.constantPool = constantPool;
        this.bootstrapMethods = bootstrapMethods;
        this.maxStack = input.readUnsignedShort();
        this.maxLocals = input.readUnsignedShort();
        this.codeData = new byte[input.readInt()];
        input.readFully(this.codeData);
        this.exceptionTable = new TryCatchFinally[input.readUnsignedShort()];
        for (int i = 0; i < this.exceptionTable.length; ++i) {
            this.exceptionTable[i] = new TryCatchFinally(input, constantPool);
        }
        this.attributes = new Attributes(input, constantPool);
    }

    public Code() {
        this.constantPool = null;
        this.bootstrapMethods = null;
        this.maxStack = 0;
        this.maxLocals = 0;
        this.codeData = new byte[0];
        this.exceptionTable = new TryCatchFinally[0];
        this.attributes = null;
        this.lineNumberTable = null;
        this.localVariableTable = null;
    }

    @NonNull
    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    @NonNull
    public TryCatchFinally[] getExceptionTable() {
        return this.exceptionTable;
    }

    public BootstrapMethods getBootstrapMethods() {
        return this.bootstrapMethods;
    }

    public LineNumberTable getLineNumberTable() throws IOException {
        if (this.lineNumberTable != null) {
            return this.lineNumberTable;
        }
        AttributeInfo data = this.attributes.get("LineNumberTable");
        if (data != null) {
            this.lineNumberTable = new LineNumberTable(data.getDataInputStream());
        }
        return this.lineNumberTable;
    }

    public LocalVariableTable getLocalVariableTable() throws IOException {
        if (this.localVariableTable != null) {
            return this.localVariableTable;
        }
        AttributeInfo data = this.attributes.get("LocalVariableTable");
        if (data != null) {
            this.localVariableTable = new LocalVariableTable(this.maxLocals, this.constantPool);
            this.localVariableTable.read(data.getDataInputStream());
        }
        return this.localVariableTable;
    }

    public int getFirstLineNr() throws IOException {
        LineNumberTable table = this.getLineNumberTable();
        if (table == null) {
            return -1;
        }
        return table.getMinLineNr();
    }

    public int getLastLineNr() throws IOException {
        LineNumberTable table = this.getLineNumberTable();
        if (table == null) {
            return -1;
        }
        return table.getMaxLineNr();
    }

    public CodeInputStream getByteCode() {
        return new CodeInputStream(this.codeData, 0, this.codeData.length, this);
    }

    public int getCodeSize() {
        return this.codeData.length;
    }

    public boolean startWithSuperInit(ConstantClass superClass) {
        if (this.codeData.length >= 4 && this.codeData[0] == 42 && this.codeData[1] == -73) {
            int idx = (this.codeData[2] & 0xFF00) + (this.codeData[3] & 0xFF);
            ConstantMethodRef method = (ConstantMethodRef)this.constantPool.get(idx);
            return method.getConstantClass() == superClass;
        }
        return false;
    }

    public boolean isSuperInitReturn(ConstantClass superClass) {
        if (this.codeData.length == 5 && this.codeData[0] == 42 && this.codeData[1] == -73 && this.codeData[4] == -79) {
            int idx = (this.codeData[2] & 0xFF00) + (this.codeData[3] & 0xFF);
            ConstantMethodRef method = (ConstantMethodRef)this.constantPool.get(idx);
            return method.getConstantClass() == superClass;
        }
        return false;
    }

    public byte[] getCodeData() {
        return this.codeData;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }
}

