/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import java.io.DataInputStream;
import java.io.IOException;

public class LineNumberTable {
    private final int[] start_pc;
    private final int[] line_number;

    public LineNumberTable(DataInputStream input) throws IOException {
        int count = input.readUnsignedShort();
        this.start_pc = new int[count];
        this.line_number = new int[count];
        for (int i = 0; i < count; ++i) {
            this.start_pc[i] = input.readUnsignedShort();
            this.line_number[i] = input.readUnsignedShort();
        }
    }

    public int size() {
        return this.start_pc.length;
    }

    public int getStartOffset(int idx) {
        return this.start_pc[idx];
    }

    public int getLineNumber(int idx) {
        return this.line_number[idx];
    }

    public int getLastLineNr() {
        return this.line_number[this.line_number.length - 1];
    }

    public int getMinLineNr() {
        int min = 65535;
        for (int nr : this.line_number) {
            min = Math.min(min, nr);
        }
        return min;
    }

    public int getMaxLineNr() {
        int max = -1;
        for (int nr : this.line_number) {
            max = Math.max(max, nr);
        }
        return max;
    }
}

