/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import com.viridiansoftware.java.attributes.LocalVariable;
import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class LocalVariableTable {
    private final int maxLocals;
    private final ConstantPool constantPool;
    private final List<LocalVariable> table;
    private int count;

    public LocalVariableTable(int maxLocals, ConstantPool constantPool) {
        this.maxLocals = maxLocals;
        this.table = new ArrayList<LocalVariable>(maxLocals + 1);
        this.constantPool = constantPool;
    }

    void read(DataInputStream input) throws IOException {
        this.count = input.readUnsignedShort();
        for (int i = 0; i < this.count; ++i) {
            LocalVariable var = new LocalVariable(input, i, this.constantPool);
            int idx = var.getIndex();
            this.table.add(var);
        }
    }

    @NonNull
    public LocalVariable getByEntryIndex(int idx) {
        return this.table.get(idx);
    }

    public int getTotalEntires() {
        return this.table.size();
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public LocalVariable get(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.table.size(); ++i) {
            if (!name.equals(this.table.get(i).getName())) continue;
            return this.table.get(i);
        }
        return null;
    }
}

