/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import com.viridiansoftware.java.attributes.AnnotationElementValuePair;
import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RuntimeVisibleAnnotation {
    private final String typeDescriptor;
    private final List<AnnotationElementValuePair> elementValuePairs = new ArrayList<AnnotationElementValuePair>();

    public RuntimeVisibleAnnotation(ConstantPool constantPool, DataInputStream input) throws IOException {
        this.typeDescriptor = (String)constantPool.get(input.readUnsignedShort());
        int totalElementValuePairs = input.readUnsignedShort();
        for (int i = 0; i < totalElementValuePairs; ++i) {
            this.elementValuePairs.add(new AnnotationElementValuePair(constantPool, input));
        }
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public AnnotationElementValuePair getElementValuePair(String name) {
        for (int i = 0; i < this.elementValuePairs.size(); ++i) {
            if (!this.elementValuePairs.get(i).getElementName().equalsIgnoreCase(name)) continue;
            return this.elementValuePairs.get(i);
        }
        return null;
    }

    public List<AnnotationElementValuePair> getElementValuePairs() {
        return this.elementValuePairs;
    }
}

