/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import com.viridiansoftware.java.attributes.RuntimeVisibleAnnotation;
import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RuntimeVisibleAnnotations {
    private final ConstantPool constantPool;
    private final List<RuntimeVisibleAnnotation> annotations = new ArrayList<RuntimeVisibleAnnotation>(2);

    public RuntimeVisibleAnnotations(ConstantPool constantPool, DataInputStream input) throws IOException {
        this.constantPool = constantPool;
        int totalAnnotations = input.readUnsignedShort();
        for (int i = 0; i < totalAnnotations; ++i) {
            this.annotations.add(new RuntimeVisibleAnnotation(constantPool, input));
        }
    }

    public RuntimeVisibleAnnotation getAnnotationByType(String classInfo) {
        if (!classInfo.startsWith("L")) {
            classInfo = "L" + classInfo + ";";
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!this.annotations.get(i).getTypeDescriptor().equalsIgnoreCase(classInfo)) continue;
            return this.annotations.get(i);
        }
        return null;
    }

    public List<RuntimeVisibleAnnotation> getAnnotations() {
        return this.annotations;
    }
}

