/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.constants;

import com.viridiansoftware.java.constants.ConstantFieldRef;
import com.viridiansoftware.java.constants.ConstantInterfaceMethodRef;
import com.viridiansoftware.java.constants.ConstantMethodRef;
import com.viridiansoftware.java.constants.ConstantRef;

public class ConstantMethodHandle {
    private final ReferenceKind referenceKind;
    private final ConstantRef reference;

    public ConstantMethodHandle(int referenceKind, ConstantRef reference) {
        this.reference = reference;
        for (ReferenceKind refKind : ReferenceKind.values()) {
            if (refKind.kind != referenceKind) continue;
            this.referenceKind = refKind;
            return;
        }
        this.referenceKind = ReferenceKind.GET_FIELD;
    }

    public String getName() {
        switch (this.referenceKind) {
            default: {
                ConstantFieldRef fieldRef = (ConstantFieldRef)this.reference;
                return fieldRef.getName();
            }
            case INVOKE_VIRTUAL: {
                ConstantMethodRef methodRef = (ConstantMethodRef)this.reference;
                return methodRef.getName();
            }
            case INVOKE_STATIC: 
            case INVOKE_SPECIAL: {
                if (this.reference instanceof ConstantInterfaceMethodRef) {
                    ConstantInterfaceMethodRef methodRef = (ConstantInterfaceMethodRef)this.reference;
                    return methodRef.getName();
                }
                ConstantMethodRef methodRef = (ConstantMethodRef)this.reference;
                return methodRef.getName();
            }
            case NEW_INVOKE_SPECIAL: {
                ConstantMethodRef methodRef = (ConstantMethodRef)this.reference;
                return methodRef.getName();
            }
            case INVOKE_INTERFACE: 
        }
        ConstantInterfaceMethodRef methodRef = (ConstantInterfaceMethodRef)this.reference;
        return methodRef.getName();
    }

    public ReferenceKind getReferenceKind() {
        return this.referenceKind;
    }

    public int getKind() {
        return this.referenceKind.kind;
    }

    public static enum ReferenceKind {
        GET_FIELD(1),
        GET_STATIC(2),
        PUT_FIELD(3),
        PUT_STATIC(4),
        INVOKE_VIRTUAL(5),
        INVOKE_STATIC(6),
        INVOKE_SPECIAL(7),
        NEW_INVOKE_SPECIAL(8),
        INVOKE_INTERFACE(9);

        public int kind;

        private ReferenceKind(int kind) {
            this.kind = kind;
        }
    }
}

