/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.constants;

import com.viridiansoftware.java.constants.ConstantClass;
import com.viridiansoftware.java.constants.ConstantDynamic;
import com.viridiansoftware.java.constants.ConstantFieldRef;
import com.viridiansoftware.java.constants.ConstantInterfaceMethodRef;
import com.viridiansoftware.java.constants.ConstantInvokeDynamic;
import com.viridiansoftware.java.constants.ConstantMethodHandle;
import com.viridiansoftware.java.constants.ConstantMethodRef;
import com.viridiansoftware.java.constants.ConstantMethodType;
import com.viridiansoftware.java.constants.ConstantNameAndType;
import com.viridiansoftware.java.constants.ConstantRef;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConstantPool {
    private final Object[] constantPool;

    public ConstantPool(int majorVersion, int minorVersion, DataInputStream input) throws IOException {
        boolean repeat;
        int count = input.readUnsignedShort();
        this.constantPool = new Object[count];
        Object[] pool = this.constantPool;
        block30: for (int i = 1; i < count; ++i) {
            byte type = input.readByte();
            switch (type) {
                case 1: {
                    pool[i] = input.readUTF();
                    continue block30;
                }
                case 3: {
                    pool[i] = new Integer(input.readInt());
                    continue block30;
                }
                case 4: {
                    pool[i] = new Float(input.readFloat());
                    continue block30;
                }
                case 5: {
                    pool[i] = new Long(input.readLong());
                    ++i;
                    continue block30;
                }
                case 6: {
                    pool[i] = new Double(input.readDouble());
                    ++i;
                    continue block30;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    pool[i] = new int[]{type, input.readUnsignedShort()};
                    continue block30;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    pool[i] = new int[]{type, input.readUnsignedShort(), input.readUnsignedShort()};
                    continue block30;
                }
                case 15: {
                    pool[i] = new int[]{type, input.readByte(), input.readUnsignedShort()};
                    continue block30;
                }
                default: {
                    throw new IOException("Unknown constant pool type: " + type);
                }
            }
        }
        do {
            repeat = false;
            block32: for (int i = 0; i < count; ++i) {
                if (!(pool[i] instanceof int[])) continue;
                int[] data = (int[])pool[i];
                switch (data[0]) {
                    case 7: {
                        pool[i] = new ConstantClass((String)pool[data[1]]);
                        continue block32;
                    }
                    case 8: {
                        pool[i] = pool[data[1]];
                        continue block32;
                    }
                    case 9: {
                        if (pool[data[1]] instanceof int[] || pool[data[2]] instanceof int[]) {
                            repeat = true;
                            continue block32;
                        }
                        pool[i] = new ConstantFieldRef((ConstantClass)pool[data[1]], (ConstantNameAndType)pool[data[2]]);
                        continue block32;
                    }
                    case 10: {
                        if (pool[data[1]] instanceof int[] || pool[data[2]] instanceof int[]) {
                            repeat = true;
                            continue block32;
                        }
                        pool[i] = new ConstantMethodRef((ConstantClass)pool[data[1]], (ConstantNameAndType)pool[data[2]]);
                        continue block32;
                    }
                    case 11: {
                        if (pool[data[1]] instanceof int[] || pool[data[2]] instanceof int[]) {
                            repeat = true;
                            continue block32;
                        }
                        pool[i] = new ConstantInterfaceMethodRef((ConstantClass)pool[data[1]], (ConstantNameAndType)pool[data[2]]);
                        continue block32;
                    }
                    case 12: {
                        pool[i] = new ConstantNameAndType((String)pool[data[1]], (String)pool[data[2]]);
                        continue block32;
                    }
                    case 15: {
                        if (pool[data[2]] instanceof int[]) {
                            repeat = true;
                            continue block32;
                        }
                        switch (data[1]) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                if (pool[data[2]] instanceof ConstantFieldRef) {
                                    pool[i] = new ConstantMethodHandle(data[1], (ConstantFieldRef)pool[data[2]]);
                                    continue block32;
                                }
                                throw new IOException("Expected " + ConstantFieldRef.class.getSimpleName() + " in constant pool index " + data[2] + " but found " + pool[data[2]].getClass().getSimpleName());
                            }
                            case 5: 
                            case 8: {
                                if (pool[data[2]] instanceof ConstantMethodRef) {
                                    pool[i] = new ConstantMethodHandle(data[1], (ConstantMethodRef)pool[data[2]]);
                                    continue block32;
                                }
                                throw new IOException("Expected " + ConstantFieldRef.class.getSimpleName() + " in constant pool index " + data[2] + " but found " + pool[data[2]].getClass().getSimpleName());
                            }
                            case 6: 
                            case 7: {
                                if (majorVersion < 52) {
                                    if (pool[data[2]] instanceof ConstantMethodRef) {
                                        pool[i] = new ConstantMethodHandle(data[1], (ConstantMethodRef)pool[data[2]]);
                                        continue block32;
                                    }
                                    throw new IOException("Expected " + ConstantMethodRef.class.getSimpleName() + " in constant pool index " + data[2] + " but found " + pool[data[2]].getClass().getSimpleName());
                                }
                                if (pool[data[2]] instanceof ConstantMethodRef) {
                                    pool[i] = new ConstantMethodHandle(data[1], (ConstantMethodRef)pool[data[2]]);
                                    continue block32;
                                }
                                if (pool[data[2]] instanceof ConstantInterfaceMethodRef) {
                                    pool[i] = new ConstantMethodHandle(data[1], (ConstantInterfaceMethodRef)pool[data[2]]);
                                    continue block32;
                                }
                                throw new IOException("Expected " + ConstantMethodRef.class.getSimpleName() + " or " + ConstantInterfaceMethodRef.class.getSimpleName() + " in constant pool index " + data[2] + " but found " + pool[data[2]].getClass().getSimpleName());
                            }
                            case 9: {
                                if (pool[data[2]] instanceof ConstantInterfaceMethodRef) {
                                    pool[i] = new ConstantMethodHandle(data[1], (ConstantInterfaceMethodRef)pool[data[2]]);
                                    continue block32;
                                }
                                throw new IOException("Expected " + ConstantInterfaceMethodRef.class.getSimpleName() + " in constant pool index " + data[2] + " but found " + pool[data[2]].getClass().getSimpleName());
                            }
                        }
                        throw new IOException("Unknown method handle reference kind: " + data[1]);
                    }
                    case 16: {
                        pool[i] = new ConstantMethodType((String)pool[data[1]]);
                        continue block32;
                    }
                    case 17: {
                        if (pool[data[2]] instanceof int[]) {
                            repeat = true;
                            continue block32;
                        }
                        pool[i] = new ConstantDynamic(data[1], (ConstantNameAndType)pool[data[2]]);
                        continue block32;
                    }
                    case 18: {
                        if (pool[data[2]] instanceof int[]) {
                            repeat = true;
                            continue block32;
                        }
                        pool[i] = new ConstantInvokeDynamic(data[1], (ConstantNameAndType)pool[data[2]]);
                        continue block32;
                    }
                    case 19: {
                        pool[i] = pool[data[1]];
                        continue block32;
                    }
                    case 20: {
                        pool[i] = pool[data[1]];
                        continue block32;
                    }
                    default: {
                        throw new IOException("Unknown constant pool type: " + data[0]);
                    }
                }
            }
        } while (repeat);
    }

    public ConstantPool(int size) {
        this.constantPool = new Object[size];
    }

    public Object get(int index) {
        return this.constantPool[index];
    }

    public void set(int index, Object obj) {
        this.constantPool[index] = obj;
    }

    public int length() {
        return this.constantPool.length;
    }

    public List<ConstantClass> getConstantClasses() {
        ArrayList<ConstantClass> result = new ArrayList<ConstantClass>();
        for (int i = 0; i < this.constantPool.length; ++i) {
            if (!(this.constantPool[i] instanceof ConstantClass)) continue;
            result.add((ConstantClass)this.constantPool[i]);
        }
        return result;
    }

    public List<String> getConstantFieldDescriptors() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.constantPool.length; ++i) {
            if (!(this.constantPool[i] instanceof ConstantFieldRef)) continue;
            result.add(((ConstantFieldRef)this.constantPool[i]).getType());
        }
        return result;
    }

    public List<String> getConstantMethodDescriptors() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.constantPool.length; ++i) {
            if (this.constantPool[i] instanceof ConstantMethodRef) {
                result.add(((ConstantMethodRef)this.constantPool[i]).getType());
                continue;
            }
            if (!(this.constantPool[i] instanceof ConstantInterfaceMethodRef)) continue;
            result.add(((ConstantInterfaceMethodRef)this.constantPool[i]).getType());
        }
        return result;
    }

    public List<ConstantRef> getConstantMethodRefs() {
        ArrayList<ConstantRef> result = new ArrayList<ConstantRef>();
        for (int i = 0; i < this.constantPool.length; ++i) {
            if (this.constantPool[i] instanceof ConstantMethodRef) {
                result.add((ConstantMethodRef)this.constantPool[i]);
                continue;
            }
            if (!(this.constantPool[i] instanceof ConstantInterfaceMethodRef)) continue;
            result.add((ConstantInterfaceMethodRef)this.constantPool[i]);
        }
        return result;
    }
}

