/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.utils;

import com.viridiansoftware.java.PrimitiveType;
import com.viridiansoftware.java.descriptor.MethodDescriptor;
import com.viridiansoftware.java.descriptor.antlr.DescriptorParser;
import com.viridiansoftware.java.signature.MethodSignature;
import com.viridiansoftware.java.signature.antlr.SignatureParser;
import com.viridiansoftware.java.utils.PrimitiveOrReferenceType;

public class ClassUtils {
    private static final String[] EMPTY_GENERICS = new String[0];

    public static boolean hasGenerics(String className) {
        if (!className.contains("<")) {
            return false;
        }
        return className.contains(">");
    }

    public static String[] getGenericTypes(String className) {
        if (!ClassUtils.hasGenerics(className)) {
            return EMPTY_GENERICS;
        }
        String genericClasses = className.substring(className.indexOf(60) + 1, className.lastIndexOf(62));
        return genericClasses.split(";");
    }

    private static void appendPackageSpecifier(StringBuilder result, SignatureParser.PackageSpecifierContext context) {
        if (context.identifier() == null) {
            return;
        }
        result.append(context.identifier().getText());
        result.append('/');
        if (context.packageSpecifier() == null) {
            return;
        }
        for (int i = 0; i < context.packageSpecifier().size(); ++i) {
            ClassUtils.appendPackageSpecifier(result, context.packageSpecifier(i));
        }
    }

    public static String getQualifiedSimpleClassName(SignatureParser.ClassTypeSignatureContext context) {
        StringBuilder result = new StringBuilder();
        ClassUtils.appendPackageSpecifier(result, context.packageSpecifier());
        result.append(context.simpleClassTypeSignature().identifier().getText());
        return result.toString();
    }

    public static boolean isSameType(MethodDescriptor expectedType, MethodSignature actualType) {
        if (actualType.getTotalMethodArguments() != expectedType.getTotalMethodParameters()) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < actualType.getTotalMethodArguments(); ++i) {
            SignatureParser.JavaTypeSignatureContext actualTypeSignature;
            DescriptorParser.FieldTypeContext expectedTypeSignature = expectedType.getMethodParameter(i);
            if (ClassUtils.isSameType(expectedTypeSignature, actualTypeSignature = actualType.getMethodArgument(i))) continue;
            match = false;
            break;
        }
        if (!match) {
            return false;
        }
        if (expectedType.isVoidMethod() && actualType.isVoidMethod()) {
            return true;
        }
        if (expectedType.isVoidMethod() && !actualType.isVoidMethod()) {
            return false;
        }
        if (!expectedType.isVoidMethod() && actualType.isVoidMethod()) {
            return false;
        }
        DescriptorParser.ReturnDescriptorContext expectedReturnTypeSignature = expectedType.getReturnDescriptor();
        SignatureParser.JavaTypeSignatureContext actualReturnTypeSignature = actualType.getReturnType();
        return ClassUtils.isSameType(expectedReturnTypeSignature.fieldType(), actualReturnTypeSignature);
    }

    public static boolean isSameType(DescriptorParser.FieldTypeContext expectedType, SignatureParser.JavaTypeSignatureContext actualType) {
        if (expectedType.BaseType() != null) {
            if (actualType.BaseType() != null) {
                return expectedType.BaseType().getText().equals(actualType.BaseType().getText());
            }
            return false;
        }
        if (expectedType.objectType() != null) {
            if (actualType.referenceTypeSignature() != null && actualType.referenceTypeSignature().classTypeSignature() != null) {
                String actualObjectType = actualType.referenceTypeSignature().classTypeSignature().getText();
                actualObjectType = actualObjectType.contains("<") ? actualObjectType.substring(0, actualObjectType.indexOf(60)) : actualObjectType.substring(0, actualObjectType.indexOf(59));
                return actualObjectType.equals("L" + expectedType.objectType().identifier().getText());
            }
            return false;
        }
        if (expectedType.arrayType() != null) {
            if (actualType.referenceTypeSignature() != null && actualType.referenceTypeSignature().arrayTypeSignature() != null) {
                DescriptorParser.ArrayTypeContext expectedArrayType = expectedType.arrayType();
                SignatureParser.ArrayTypeSignatureContext actualArrayType = actualType.referenceTypeSignature().arrayTypeSignature();
                while (expectedArrayType != null) {
                    if (expectedArrayType.fieldType().arrayType() != null) {
                        if (actualArrayType.javaTypeSignature().referenceTypeSignature() == null) {
                            return false;
                        }
                        if (actualArrayType.javaTypeSignature().referenceTypeSignature().arrayTypeSignature() == null) {
                            return false;
                        }
                        expectedArrayType = expectedArrayType.fieldType().arrayType();
                        actualArrayType = actualArrayType.javaTypeSignature().referenceTypeSignature().arrayTypeSignature();
                        continue;
                    }
                    if (expectedArrayType.fieldType().objectType() != null) {
                        if (actualArrayType.javaTypeSignature().referenceTypeSignature() == null) {
                            return false;
                        }
                        if (actualArrayType.javaTypeSignature().referenceTypeSignature().classTypeSignature() == null) {
                            return false;
                        }
                        String actualObjectType = actualArrayType.javaTypeSignature().referenceTypeSignature().classTypeSignature().getText();
                        actualObjectType = actualObjectType.contains("<") ? actualObjectType.substring(0, actualObjectType.indexOf(60)) : actualObjectType.substring(0, actualObjectType.indexOf(59));
                        return actualObjectType.equals("L" + expectedArrayType.fieldType().objectType().identifier().getText());
                    }
                    if (actualArrayType.javaTypeSignature().BaseType() == null) {
                        return false;
                    }
                    return expectedArrayType.fieldType().BaseType().getText().equals(actualArrayType.javaTypeSignature().BaseType().getText());
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isArray(String name) {
        return name.startsWith("[");
    }

    public static int getArrayDimensions(String name) {
        int totalDimensions = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '[') continue;
            ++totalDimensions;
        }
        return totalDimensions;
    }

    public static boolean isPrimitive(String name) {
        return !name.startsWith("L") && !name.startsWith("[");
    }

    public static boolean isObject(String name) {
        return name.startsWith("L");
    }

    public static boolean isArrayOfPrimitives(String name) {
        if (!name.startsWith("[")) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (name.charAt(i) == '[') continue;
            return name.charAt(i) != 'L';
        }
        return false;
    }

    public static boolean isArrayOfObjects(String name) {
        if (!name.startsWith("[")) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (name.charAt(i) == '[') continue;
            return name.charAt(i) == 'L';
        }
        return false;
    }

    public static PrimitiveType getPrimitiveType(String name) {
        while (name.charAt(0) == '[') {
            name = name.substring(1);
        }
        return ClassUtils.getPrimitiveType(name.charAt(0));
    }

    public static PrimitiveType getPrimitiveType(char c) {
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            if (c != primitiveType.getTerm()) continue;
            return primitiveType;
        }
        return null;
    }

    static PrimitiveOrReferenceType getPrimitiveOrReferenceType(char c) {
        for (PrimitiveOrReferenceType primitiveOrRefType : PrimitiveOrReferenceType.values()) {
            if (c != primitiveOrRefType.getTerm()) continue;
            return primitiveOrRefType;
        }
        return null;
    }

    public static String getReferenceClass(String name) {
        int offset = 0;
        block0 : switch (name.charAt(0)) {
            case '[': {
                offset = 1;
                for (int i = 1; i < name.length(); ++i) {
                    if (name.charAt(i) == '[') {
                        ++offset;
                        continue;
                    }
                    if (name.charAt(i) == 'L') {
                        ++offset;
                        break block0;
                    }
                    return null;
                }
                break;
            }
            case 'L': {
                offset = 1;
                break;
            }
            default: {
                for (PrimitiveOrReferenceType typeOrRef : PrimitiveOrReferenceType.values()) {
                    if (typeOrRef.getTerm() != name.charAt(0)) continue;
                    return null;
                }
            }
        }
        if (name.endsWith(";")) {
            name = name.substring(offset);
            return name.substring(0, name.length() - 1);
        }
        return name.substring(offset);
    }
}

