/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java;

import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Annotations {
    static Map<String, Map<String, Object>> read(DataInputStream input, ConstantPool constantPool) throws IOException {
        HashMap<String, Map<String, Object>> annotations = new HashMap<String, Map<String, Object>>();
        int count = input.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            String className = (String)constantPool.get(input.readUnsignedShort());
            className = className.substring(1, className.length() - 1).replace('/', '.');
            HashMap<String, Object> valuePairs = new HashMap<String, Object>();
            annotations.put(className, valuePairs);
            int valuePairCount = input.readUnsignedShort();
            for (int p = 0; p < valuePairCount; ++p) {
                Object value;
                String key = (String)constantPool.get(input.readUnsignedShort());
                int type = input.readUnsignedByte();
                switch (type) {
                    case 66: 
                    case 67: 
                    case 68: 
                    case 70: 
                    case 73: 
                    case 74: 
                    case 83: 
                    case 90: 
                    case 115: {
                        value = constantPool.get(input.readUnsignedShort());
                        break;
                    }
                    default: {
                        throw new IOException("Unknown annotation value type pool type: " + type);
                    }
                }
                valuePairs.put(key, value);
            }
        }
        return annotations;
    }
}

