/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java;

import com.viridiansoftware.java.attributes.Code;
import com.viridiansoftware.java.attributes.LineNumberTable;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class CodeInputStream
extends DataInputStream {
    private Code code;

    public CodeInputStream(byte[] buf, int offset, int length, Code code) {
        this(new ByteCodeArrayInputStream(buf, offset, length));
        this.code = code;
    }

    private CodeInputStream(ByteCodeArrayInputStream in) {
        super(in);
    }

    public int getCodePosition() {
        return ((ByteCodeArrayInputStream)this.in).getCodePosition();
    }

    public int getLineNumber() {
        int lineNumber = -1;
        try {
            LineNumberTable lineNumberTable = this.code.getLineNumberTable();
            if (lineNumberTable != null) {
                int offset;
                int codePos = this.getCodePosition();
                for (int i = 0; i < lineNumberTable.size() && (offset = lineNumberTable.getStartOffset(i)) <= codePos; ++i) {
                    lineNumber = lineNumberTable.getLineNumber(i);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lineNumber;
    }

    public int readUnsignedIndex(boolean wide) throws IOException {
        return wide ? this.readUnsignedShort() : this.readUnsignedByte();
    }

    private static class ByteCodeArrayInputStream
    extends ByteArrayInputStream {
        ByteCodeArrayInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        int getCodePosition() {
            return this.pos;
        }
    }
}

