/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java;

import com.viridiansoftware.java.ClassFile;
import com.viridiansoftware.java.Exceptions;
import com.viridiansoftware.java.Member;
import com.viridiansoftware.java.MethodAccessFlag;
import com.viridiansoftware.java.MethodParameters;
import com.viridiansoftware.java.ResolvedTypeVariable;
import com.viridiansoftware.java.TypeVariableResolver;
import com.viridiansoftware.java.UnresolvedTypeVariableException;
import com.viridiansoftware.java.attributes.AnnotationDefault;
import com.viridiansoftware.java.attributes.AttributeInfo;
import com.viridiansoftware.java.attributes.Attributes;
import com.viridiansoftware.java.attributes.Code;
import com.viridiansoftware.java.attributes.RuntimeVisibleAnnotations;
import com.viridiansoftware.java.attributes.RuntimeVisibleParameterAnnotations;
import com.viridiansoftware.java.constants.ConstantNameAndType;
import com.viridiansoftware.java.constants.ConstantPool;
import com.viridiansoftware.java.descriptor.MethodDescriptor;
import com.viridiansoftware.java.signature.ClassSignature;
import com.viridiansoftware.java.signature.MethodSignature;
import com.viridiansoftware.java.signature.antlr.SignatureParser;
import com.viridiansoftware.java.utils.ClassUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodInfo
implements Member,
TypeVariableResolver {
    private final int accessFlags;
    private final List<MethodAccessFlag> methodAccessFlags = new ArrayList<MethodAccessFlag>(4);
    private final String name;
    private final String description;
    private final Attributes attributes;
    private final ConstantPool constantPool;
    private Code code;
    private Exceptions exceptions;
    private ClassFile classFile;
    private RuntimeVisibleAnnotations runtimeVisibleAnnotations;
    private RuntimeVisibleParameterAnnotations runtimeVisibleParameterAnnotations;
    private AnnotationDefault annotationDefault;
    private String signature;
    private MethodParameters methodParameters;
    private MethodSignature methodSignature;
    private MethodDescriptor methodDescriptor;

    MethodInfo(DataInputStream input, ConstantPool constantPool, ClassFile classFile) throws IOException {
        this.accessFlags = input.readUnsignedShort();
        for (MethodAccessFlag methodAccessFlag : MethodAccessFlag.values()) {
            if ((methodAccessFlag.getMask() & this.accessFlags) != methodAccessFlag.getMask()) continue;
            this.methodAccessFlags.add(methodAccessFlag);
        }
        this.name = (String)constantPool.get(input.readUnsignedShort());
        this.description = (String)constantPool.get(input.readUnsignedShort());
        this.constantPool = constantPool;
        this.attributes = new Attributes(input, constantPool);
        this.classFile = classFile;
    }

    public ClassFile getDeclaringClassFile() {
        return this.classFile;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public List<MethodAccessFlag> getMethodAccessFlags() {
        return this.methodAccessFlags;
    }

    public boolean isStatic() {
        return (this.accessFlags & MethodAccessFlag.STATIC.getMask()) == MethodAccessFlag.STATIC.getMask();
    }

    public boolean isDefaultScope() {
        if (this.isPrivate()) {
            return false;
        }
        if (this.isPublic()) {
            return false;
        }
        return !this.isProtected();
    }

    public boolean isPublic() {
        return (this.accessFlags & MethodAccessFlag.PUBLIC.getMask()) == MethodAccessFlag.PUBLIC.getMask();
    }

    public boolean isProtected() {
        return (this.accessFlags & MethodAccessFlag.PROTECTED.getMask()) == MethodAccessFlag.PROTECTED.getMask();
    }

    public boolean isPrivate() {
        return (this.accessFlags & MethodAccessFlag.PRIVATE.getMask()) == MethodAccessFlag.PRIVATE.getMask();
    }

    public boolean isNative() {
        return (this.accessFlags & MethodAccessFlag.NATIVE.getMask()) == MethodAccessFlag.NATIVE.getMask();
    }

    public boolean isAbstract() {
        return (this.accessFlags & MethodAccessFlag.ABSTRACT.getMask()) == MethodAccessFlag.ABSTRACT.getMask();
    }

    public boolean isFinal() {
        return (this.accessFlags & MethodAccessFlag.FINAL.getMask()) == MethodAccessFlag.FINAL.getMask();
    }

    public boolean isSynchronized() {
        return (this.accessFlags & MethodAccessFlag.SYNCHRONIZED.getMask()) == MethodAccessFlag.SYNCHRONIZED.getMask();
    }

    public boolean isSynthetic() {
        return (this.accessFlags & MethodAccessFlag.SYNTHETIC.getMask()) == MethodAccessFlag.SYNTHETIC.getMask();
    }

    public boolean isBridge() {
        return (this.accessFlags & MethodAccessFlag.BRIDGE.getMask()) == MethodAccessFlag.BRIDGE.getMask();
    }

    public boolean isVarArgs() {
        return (this.accessFlags & MethodAccessFlag.VARARGS.getMask()) == MethodAccessFlag.VARARGS.getMask();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClassName() {
        return this.getDeclaringClassFile().getThisClass().getName();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public AnnotationDefault getAnnotationDefault() throws IOException {
        AttributeInfo info;
        if (this.annotationDefault == null && (info = this.getAttributes().get("AnnotationDefault")) != null) {
            this.annotationDefault = new AnnotationDefault(this.constantPool, info);
        }
        return this.annotationDefault;
    }

    public RuntimeVisibleAnnotations getRuntimeVisibleAnnotations() throws IOException {
        AttributeInfo info;
        if (this.runtimeVisibleAnnotations == null && (info = this.getAttributes().get("RuntimeVisibleAnnotations")) != null) {
            this.runtimeVisibleAnnotations = new RuntimeVisibleAnnotations(this.constantPool, info.getDataInputStream());
        }
        return this.runtimeVisibleAnnotations;
    }

    public RuntimeVisibleParameterAnnotations getRuntimeVisibleParameterAnnotations() throws IOException {
        AttributeInfo info;
        if (this.runtimeVisibleParameterAnnotations == null && (info = this.getAttributes().get("RuntimeVisibleParameterAnnotations")) != null) {
            this.runtimeVisibleParameterAnnotations = new RuntimeVisibleParameterAnnotations(this.constantPool, info.getDataInputStream());
        }
        return this.runtimeVisibleParameterAnnotations;
    }

    public Code getCode() throws IOException {
        if (this.code != null) {
            return this.code;
        }
        AttributeInfo data = this.attributes.get("Code");
        if (data != null) {
            this.code = new Code(data.getDataInputStream(), this.constantPool, this.classFile.getBootstrapMethods());
        }
        return this.code;
    }

    @Override
    public String getType() {
        return this.description;
    }

    public String getSignature() throws IOException {
        if (this.signature != null) {
            return this.signature;
        }
        AttributeInfo info = this.getAttributes().get("Signature");
        if (info != null) {
            short idx = info.getDataInputStream().readShort();
            this.signature = (String)this.constantPool.get(idx);
        }
        return this.signature;
    }

    public MethodParameters getMethodParameters() throws IOException {
        if (this.methodParameters != null) {
            return this.methodParameters;
        }
        AttributeInfo info = this.getAttributes().get("MethodParameters");
        this.methodParameters = info != null ? new MethodParameters(info.getDataInputStream(), this.constantPool) : new MethodParameters(new String[0]);
        return this.methodParameters;
    }

    public MethodDescriptor getMethodDescriptor() {
        if (this.methodDescriptor == null) {
            this.methodDescriptor = new MethodDescriptor(this.getType());
        }
        return this.methodDescriptor;
    }

    public MethodSignature getMethodSignature() throws IOException {
        if (this.methodSignature == null) {
            this.methodSignature = this.getSignature() != null ? new MethodSignature(this.getSignature()) : new MethodSignature(this.getType());
        }
        return this.methodSignature;
    }

    public boolean isVoidMethod() throws IOException {
        return this.getMethodSignature().isVoidMethod();
    }

    public int getTotalTypeParameters() throws IOException {
        return this.getMethodSignature().getTotalTypeParameters();
    }

    public SignatureParser.TypeParameterContext getTypeParameter(int i) throws IOException {
        return this.getMethodSignature().getTypeParameter(i);
    }

    public int getTotalMethodArguments() throws IOException {
        if (this.getMethodDescriptor() != null) {
            return this.getMethodDescriptor().getTotalMethodParameters();
        }
        if (this.getMethodSignature() != null) {
            return this.getMethodSignature().getTotalMethodArguments();
        }
        return this.getMethodParameters().getParameterNames().length;
    }

    public String getMethodArgumentName(int i) throws IOException {
        try {
            return this.getMethodParameters().getParameterNames()[i];
        }
        catch (Exception exception) {
            return "arg" + i;
        }
    }

    public SignatureParser.JavaTypeSignatureContext getMethodArgumentType(int i) throws IOException {
        return this.getMethodSignature().getMethodArgument(i);
    }

    public int getTotalThrowsSignatures() throws IOException {
        return this.getMethodSignature().getTotalThrowsSignatures();
    }

    public SignatureParser.ThrowsSignatureContext getThrowsSignature(int i) throws IOException {
        return this.getMethodSignature().getThrowsSignature(i);
    }

    @Override
    public ResolvedTypeVariable resolveTypeVariable(String variableName) throws UnresolvedTypeVariableException, IOException {
        if (variableName.startsWith("T")) {
            variableName = variableName.substring(1);
        }
        for (int i = 0; i < this.methodSignature.getTotalTypeParameters(); ++i) {
            SignatureParser.TypeParameterContext typeParameterContext = this.methodSignature.getTypeParameter(i);
            if (!typeParameterContext.identifier().getText().equals(variableName) || typeParameterContext.classBound().referenceTypeSignature() == null && typeParameterContext.interfaceBounds() == null) continue;
            return new ResolvedTypeVariable(variableName, typeParameterContext);
        }
        return this.classFile.resolveTypeVariable(variableName);
    }

    public SignatureParser.JavaTypeSignatureContext getResultSignature() throws IOException {
        return this.getMethodSignature().getReturnType();
    }

    public boolean matches(ConstantNameAndType constantNameAndType) throws IOException {
        if (!this.getName().equals(constantNameAndType.getName())) {
            return false;
        }
        if (this.description != null) {
            return this.description.equals(constantNameAndType.getType());
        }
        return ClassUtils.isSameType(constantNameAndType.asMethodDescriptor(), this.getMethodSignature());
    }

    public boolean isImplementationOf(MethodInfo methodInfo) throws IOException {
        return this.isImplementationOf(methodInfo, true, false);
    }

    public boolean isImplementationOf(MethodInfo methodInfo, boolean allowErasedMatch, boolean allowSyntheicImplementations) throws IOException {
        if (!this.getName().equals(methodInfo.getName())) {
            return false;
        }
        if (!allowSyntheicImplementations && this.isSynthetic()) {
            return false;
        }
        if ((methodInfo.getSignature() != null && allowErasedMatch || methodInfo.getSignature() == null) && this.description != null && methodInfo.getType() != null && this.description.equals(methodInfo.getType())) {
            return true;
        }
        if (methodInfo.getSignature() != null) {
            return this.isImplementationOf(methodInfo.getDeclaringClassFile(), methodInfo.getMethodSignature());
        }
        return false;
    }

    public boolean isImplementationOf(MethodInfo methodInfo, boolean allowSyntheicImplementations) throws IOException {
        if (!this.getName().equals(methodInfo.getName())) {
            return false;
        }
        if (!allowSyntheicImplementations && this.isSynthetic()) {
            return false;
        }
        if (this.description != null && methodInfo.getType() != null && this.description.equals(methodInfo.getType())) {
            return true;
        }
        if (methodInfo.getSignature() != null) {
            return this.isImplementationOf(methodInfo.getDeclaringClassFile(), methodInfo.getMethodSignature());
        }
        return false;
    }

    public boolean isImplementationOf(ClassFile declaringFile, MethodSignature methodSignature) throws IOException {
        int i;
        String superClassWithoutGenerics;
        if (declaringFile.getClassSignature() == null || this.getDeclaringClassFile().getClassSignature() == null) {
            if (this.getMethodSignature() != null) {
                return this.getMethodSignature().getSignatureContext().getText().equals(methodSignature.getSignatureContext().getText());
            }
            return false;
        }
        if (!methodSignature.isVoidMethod() && this.isVoidMethod()) {
            return false;
        }
        if (methodSignature.isVoidMethod() && !this.isVoidMethod()) {
            return false;
        }
        if (methodSignature.getTotalMethodArguments() != this.getTotalMethodArguments()) {
            return false;
        }
        ClassSignature methodClassSignature = declaringFile.getClassSignature();
        String methodClassWithoutGenerics = declaringFile.getThisSignature();
        HashMap<String, String> resolvedTypes = new HashMap<String, String>();
        ClassSignature thisClassSignature = this.getDeclaringClassFile().getClassSignature();
        if (thisClassSignature.getSuperclass() != null && thisClassSignature.getSuperclass().classTypeSignature() != null && (superClassWithoutGenerics = (superClassWithoutGenerics = thisClassSignature.getSuperclass().classTypeSignature().getText()).contains("<") ? superClassWithoutGenerics.substring(1, superClassWithoutGenerics.indexOf(60)) : superClassWithoutGenerics.substring(1, superClassWithoutGenerics.indexOf(59))).equals(methodClassWithoutGenerics)) {
            for (int i2 = 0; i2 < methodClassSignature.getTotalTypeParameters(); ++i2) {
                String identifier = methodClassSignature.getTypeParameter(i2).identifier().getText();
                if (thisClassSignature.getSuperclass().classTypeSignature().simpleClassTypeSignature().typeArguments() != null && thisClassSignature.getSuperclass().classTypeSignature().simpleClassTypeSignature().typeArguments().typeArgument() != null) {
                    resolvedTypes.put(identifier, thisClassSignature.getSuperclass().classTypeSignature().simpleClassTypeSignature().typeArguments().typeArgument(i2).getText());
                    continue;
                }
                resolvedTypes.put(identifier, "Ljava/lang/Object;");
            }
        }
        for (i = 0; i < thisClassSignature.getTotalSuperinterfaces(); ++i) {
            SignatureParser.SuperinterfaceSignatureContext superinterfaceSignatureContext = thisClassSignature.getSuperinterface(i);
            String superInterfaceWithoutGenerics = thisClassSignature.getSuperclass().classTypeSignature().getText();
            superInterfaceWithoutGenerics = superInterfaceWithoutGenerics.contains("<") ? superInterfaceWithoutGenerics.substring(1, superInterfaceWithoutGenerics.indexOf(60)) : superInterfaceWithoutGenerics.substring(1, superInterfaceWithoutGenerics.indexOf(59));
            if (!superInterfaceWithoutGenerics.equals(methodClassWithoutGenerics)) continue;
            for (int j = 0; j < methodClassSignature.getTotalTypeParameters(); ++j) {
                String identifier = methodClassSignature.getTypeParameter(j).identifier().getText();
                if (superinterfaceSignatureContext.classTypeSignature().simpleClassTypeSignature().typeArguments() != null && superinterfaceSignatureContext.classTypeSignature().simpleClassTypeSignature().typeArguments().typeArgument() != null) {
                    resolvedTypes.put(identifier, superinterfaceSignatureContext.classTypeSignature().simpleClassTypeSignature().typeArguments().typeArgument(j).getText());
                    continue;
                }
                resolvedTypes.put(identifier, "Ljava/lang/Object;");
            }
        }
        if (!(methodSignature.isVoidMethod() || this.isVoidMethod() || this.isSameType(resolvedTypes, methodSignature.getReturnType(), this.getResultSignature()))) {
            return false;
        }
        for (i = 0; i < methodSignature.getTotalMethodArguments(); ++i) {
            if (this.isSameType(resolvedTypes, methodSignature.getMethodArgument(i), this.getMethodArgumentType(i))) continue;
            return false;
        }
        return true;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    private boolean isSameType(Map<String, String> resolvedType, List<SignatureParser.ClassTypeSignatureSuffixContext> returnType1, List<SignatureParser.ClassTypeSignatureSuffixContext> returnType2) {
        if (returnType1.size() != returnType2.size()) {
            return false;
        }
        for (int i = 0; i < returnType1.size(); ++i) {
            if (this.isSameType(resolvedType, returnType1.get(i).simpleClassTypeSignature(), returnType2.get(i).simpleClassTypeSignature())) continue;
            return false;
        }
        return true;
    }

    private boolean isSameType(Map<String, String> resolvedType, SignatureParser.SimpleClassTypeSignatureContext returnType1, SignatureParser.SimpleClassTypeSignatureContext returnType2) {
        if (returnType1.typeArguments() != null && returnType2.typeArguments() == null) {
            return false;
        }
        if (returnType1.typeArguments() == null && returnType2.typeArguments() != null) {
            return false;
        }
        if (returnType1.typeArguments() != null && returnType2.typeArguments() != null) {
            if (returnType1.typeArguments().typeArgument() != null && returnType2.typeArguments().typeArgument() == null) {
                return false;
            }
            if (returnType1.typeArguments().typeArgument() == null && returnType2.typeArguments().typeArgument() != null) {
                return false;
            }
            if (returnType1.typeArguments().typeArgument() != null && returnType2.typeArguments().typeArgument() != null) {
                if (returnType1.typeArguments().typeArgument().size() != returnType2.typeArguments().typeArgument().size()) {
                    return false;
                }
                for (int i = 0; i < returnType1.typeArguments().typeArgument().size(); ++i) {
                    if (returnType1.typeArguments().typeArgument(i).ASTERISK() != null || returnType2.typeArguments().typeArgument(i).ASTERISK() != null || returnType1.typeArguments().typeArgument(i).referenceTypeSignature() == null || returnType2.typeArguments().typeArgument(i).referenceTypeSignature() == null || this.isSameType(resolvedType, returnType1.typeArguments().typeArgument(i).referenceTypeSignature(), returnType2.typeArguments().typeArgument(i).referenceTypeSignature())) continue;
                    return false;
                }
            }
        }
        return returnType1.identifier().getText().equals(returnType2.identifier().getText());
    }

    private boolean isSameType(Map<String, String> resolvedTypes, SignatureParser.ClassTypeSignatureContext returnType1, SignatureParser.ClassTypeSignatureContext returnType2) {
        if (returnType1.packageSpecifier() != null && returnType2.packageSpecifier() == null) {
            return false;
        }
        if (returnType1.packageSpecifier() == null && returnType2.packageSpecifier() != null) {
            return false;
        }
        if (returnType1.packageSpecifier() != null && returnType2.packageSpecifier() != null) {
            SignatureParser.PackageSpecifierContext specifierContext1 = returnType1.packageSpecifier();
            SignatureParser.PackageSpecifierContext specifierContext2 = returnType2.packageSpecifier();
            while (specifierContext1 != null || specifierContext2 != null) {
                if (specifierContext1 != null && specifierContext2 == null) {
                    return false;
                }
                if (specifierContext1 == null && specifierContext2 != null) {
                    return false;
                }
                if (!specifierContext1.identifier().getText().equals(specifierContext2.identifier().getText())) {
                    return false;
                }
                specifierContext1 = specifierContext1.packageSpecifier() != null ? specifierContext1.packageSpecifier(0) : null;
                specifierContext2 = specifierContext2.packageSpecifier() != null ? specifierContext2.packageSpecifier(0) : null;
            }
        }
        if (!this.isSameType(resolvedTypes, returnType1.simpleClassTypeSignature(), returnType2.simpleClassTypeSignature())) {
            return false;
        }
        if (returnType1.classTypeSignatureSuffix() != null && returnType2.classTypeSignatureSuffix() == null) {
            return false;
        }
        if (returnType1.classTypeSignatureSuffix() == null && returnType2.classTypeSignatureSuffix() != null) {
            return false;
        }
        if (returnType1.classTypeSignatureSuffix() != null && returnType2.classTypeSignatureSuffix() != null) {
            return this.isSameType(resolvedTypes, returnType1.classTypeSignatureSuffix(), returnType2.classTypeSignatureSuffix());
        }
        return true;
    }

    private boolean isSameType(Map<String, String> resolvedTypes, SignatureParser.ReferenceTypeSignatureContext returnType1, SignatureParser.ReferenceTypeSignatureContext returnType2) {
        if (returnType1.classTypeSignature() != null && returnType2.classTypeSignature() != null) {
            return this.isSameType(resolvedTypes, returnType1.classTypeSignature(), returnType2.classTypeSignature());
        }
        if (returnType1.arrayTypeSignature() != null && returnType2.arrayTypeSignature() != null) {
            return this.isSameType(resolvedTypes, returnType1.arrayTypeSignature().javaTypeSignature(), returnType2.arrayTypeSignature().javaTypeSignature());
        }
        if (returnType1.typeVariableSignature() != null || returnType2.typeVariableSignature() != null) {
            String class1 = "";
            String class2 = "";
            if (returnType1.typeVariableSignature() != null && resolvedTypes.containsKey(returnType1.typeVariableSignature().identifier().getText())) {
                class1 = resolvedTypes.get(returnType1.typeVariableSignature().identifier().getText());
            } else if (returnType1.classTypeSignature() != null && (class1 = returnType1.classTypeSignature().getText()).contains("<")) {
                class1 = class1.substring(0, class1.indexOf(60)) + ";";
            }
            if (returnType2.typeVariableSignature() != null && resolvedTypes.containsKey(returnType2.typeVariableSignature().identifier().getText())) {
                class2 = resolvedTypes.get(returnType2.typeVariableSignature().identifier().getText());
            } else if (returnType2.classTypeSignature() != null && (class2 = returnType2.classTypeSignature().getText()).contains("<")) {
                class2 = class2.substring(0, class2.indexOf(60)) + ";";
            }
            return class1.equals(class2);
        }
        return false;
    }

    private boolean isSameType(Map<String, String> resolvedTypes, SignatureParser.JavaTypeSignatureContext returnType1, SignatureParser.JavaTypeSignatureContext returnType2) {
        if (returnType1.getText().equals(returnType2.getText())) {
            return true;
        }
        if (returnType1.BaseType() != null && returnType2.BaseType() != null) {
            return returnType1.BaseType().getText().equals(returnType2.BaseType().getText());
        }
        if (returnType1.referenceTypeSignature() != null && returnType2.referenceTypeSignature() != null) {
            return this.isSameType(resolvedTypes, returnType1.referenceTypeSignature(), returnType2.referenceTypeSignature());
        }
        return false;
    }
}

