/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java;

import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class MethodParameters {
    private final String[] parameterNames;
    private final int[] parameterAccessFlags;

    public MethodParameters(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int parameterCount = dataInputStream.readUnsignedByte();
        this.parameterNames = new String[parameterCount];
        this.parameterAccessFlags = new int[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            this.parameterNames[i] = (String)constantPool.get(dataInputStream.readUnsignedShort());
            this.parameterAccessFlags[i] = dataInputStream.readUnsignedShort();
        }
    }

    public MethodParameters(String[] parameterNames) {
        this.parameterNames = parameterNames;
        this.parameterAccessFlags = new int[parameterNames.length];
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public int[] getParameterAccessFlags() {
        return this.parameterAccessFlags;
    }
}

