/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import com.viridiansoftware.java.attributes.AnnotationElementValue;
import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class AnnotationElementValuePair {
    private final String elementName;
    private final char elementTag;
    private final AnnotationElementValue elementValue;

    public AnnotationElementValuePair(ConstantPool constantPool, DataInputStream input) throws IOException {
        this.elementName = (String)constantPool.get(input.readUnsignedShort());
        this.elementTag = (char)input.readUnsignedByte();
        this.elementValue = AnnotationElementValue.create(this.elementTag, constantPool, input);
    }

    public String getElementName() {
        return this.elementName;
    }

    public AnnotationElementValue getElementValue() {
        return this.elementValue;
    }

    public boolean isByte() {
        return this.elementTag == 'B';
    }

    public boolean isChar() {
        return this.elementTag == 'C';
    }

    public boolean isDouble() {
        return this.elementTag == 'D';
    }

    public boolean isFloat() {
        return this.elementTag == 'F';
    }

    public boolean isInt() {
        return this.elementTag == 'I';
    }

    public boolean isLong() {
        return this.elementTag == 'J';
    }

    public boolean isShort() {
        return this.elementTag == 'S';
    }

    public boolean isBoolean() {
        return this.elementTag == 'Z';
    }

    public boolean isString() {
        return this.elementTag == 's';
    }

    public boolean isEnum() {
        return this.elementTag == 'e';
    }

    public boolean isClass() {
        return this.elementTag == 'c';
    }

    public boolean isAnnotation() {
        return this.elementTag == '@';
    }

    public boolean isArray() {
        return this.elementTag == '[';
    }
}

