/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import com.viridiansoftware.java.attributes.AnnotationElementValue;
import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class ConstElementValue
extends AnnotationElementValue {
    private final char tag;
    private final Object value;

    public ConstElementValue(char tag, ConstantPool constantPool, DataInputStream input) throws IOException {
        this.tag = tag;
        this.value = constantPool.get(input.readUnsignedShort());
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isByte() {
        return this.tag == 'B';
    }

    public boolean isChar() {
        return this.tag == 'C';
    }

    public boolean isDouble() {
        return this.tag == 'D';
    }

    public boolean isFloat() {
        return this.tag == 'F';
    }

    public boolean isInt() {
        return this.tag == 'I';
    }

    public boolean isLong() {
        return this.tag == 'J';
    }

    public boolean isShort() {
        return this.tag == 'S';
    }

    public boolean isBoolean() {
        return this.tag == 'Z';
    }

    public boolean isString() {
        return this.tag == 's';
    }
}

