/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import com.viridiansoftware.java.ClassAccessFlag;
import com.viridiansoftware.java.constants.ConstantClass;
import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InnerClassRef {
    private final ConstantClass innerClass;
    private final ConstantClass outerClass;
    private final String innerName;
    private final int accessFlags;
    private List<ClassAccessFlag> classAccessFlags;

    public InnerClassRef(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.innerClass = (ConstantClass)constantPool.get(dataInputStream.readUnsignedShort());
        int outerClassIndex = dataInputStream.readUnsignedShort();
        this.outerClass = outerClassIndex > 0 ? (ConstantClass)constantPool.get(outerClassIndex) : null;
        this.innerName = (String)constantPool.get(dataInputStream.readUnsignedShort());
        this.accessFlags = dataInputStream.readUnsignedShort();
    }

    public List<ClassAccessFlag> getClassAccessFlags() {
        if (this.classAccessFlags == null) {
            this.classAccessFlags = new ArrayList<ClassAccessFlag>(1);
            for (ClassAccessFlag accessFlag : ClassAccessFlag.values()) {
                if ((accessFlag.getMask() & this.accessFlags) != accessFlag.getMask()) continue;
                this.classAccessFlags.add(accessFlag);
            }
        }
        return this.classAccessFlags;
    }

    public ConstantClass getInnerClass() {
        return this.innerClass;
    }

    public ConstantClass getOuterClass() {
        return this.outerClass;
    }

    public String getInnerName() {
        return this.innerName;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }
}

