/*
 * Decompiled with CFR 0.152.
 */
package com.viridiansoftware.java.attributes;

import com.viridiansoftware.java.constants.ConstantClass;
import com.viridiansoftware.java.constants.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import lombok.NonNull;

public class TryCatchFinally {
    private final int start;
    private final int end;
    private final int handler;
    private final ConstantClass type;

    public TryCatchFinally(DataInputStream input, @NonNull ConstantPool constantPool) throws IOException {
        if (constantPool == null) {
            throw new NullPointerException("constantPool is marked @NonNull but is null");
        }
        this.start = input.readUnsignedShort();
        this.end = input.readUnsignedShort();
        this.handler = input.readUnsignedShort();
        this.type = (ConstantClass)constantPool.get(input.readUnsignedShort());
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getHandler() {
        return this.handler;
    }

    public ConstantClass getType() {
        return this.type;
    }

    public boolean isFinally() {
        return this.type == null;
    }
}

